<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CalculateSurchargeAmount StructType
 * @subpackage Structs
 */
class CalculateSurchargeAmount extends AbstractStructBase
{
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $amount;
    /**
     * The securityToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\SecurityToken
     */
    public $securityToken;
    /**
     * The cardNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $cardNumber;
    /**
     * The cardZipCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $cardZipCode;
    /**
     * The customerInternalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $customerInternalId;
    /**
     * The paymentMethodId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $paymentMethodId;
    /**
     * Constructor method for CalculateSurchargeAmount
     * @uses CalculateSurchargeAmount::setAmount()
     * @uses CalculateSurchargeAmount::setSecurityToken()
     * @uses CalculateSurchargeAmount::setCardNumber()
     * @uses CalculateSurchargeAmount::setCardZipCode()
     * @uses CalculateSurchargeAmount::setCustomerInternalId()
     * @uses CalculateSurchargeAmount::setPaymentMethodId()
     * @param float $amount
     * @param \eBizCharge\StructType\SecurityToken $securityToken
     * @param string $cardNumber
     * @param string $cardZipCode
     * @param string $customerInternalId
     * @param string $paymentMethodId
     */
    public function __construct($amount = null, \eBizCharge\StructType\SecurityToken $securityToken = null, $cardNumber = null, $cardZipCode = null, $customerInternalId = null, $paymentMethodId = null)
    {
        $this
            ->setAmount($amount)
            ->setSecurityToken($securityToken)
            ->setCardNumber($cardNumber)
            ->setCardZipCode($cardZipCode)
            ->setCustomerInternalId($customerInternalId)
            ->setPaymentMethodId($paymentMethodId);
    }
    /**
     * Get amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param float $amount
     * @return \eBizCharge\StructType\CalculateSurchargeAmount
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get securityToken value
     * @return \eBizCharge\StructType\SecurityToken|null
     */
    public function getSecurityToken()
    {
        return $this->securityToken;
    }
    /**
     * Set securityToken value
     * @param \eBizCharge\StructType\SecurityToken $securityToken
     * @return \eBizCharge\StructType\CalculateSurchargeAmount
     */
    public function setSecurityToken(\eBizCharge\StructType\SecurityToken $securityToken = null)
    {
        $this->securityToken = $securityToken;
        return $this;
    }
    /**
     * Get cardNumber value
     * @return string|null
     */
    public function getCardNumber()
    {
        return $this->cardNumber;
    }
    /**
     * Set cardNumber value
     * @param string $cardNumber
     * @return \eBizCharge\StructType\CalculateSurchargeAmount
     */
    public function setCardNumber($cardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cardNumber) && !is_string($cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardNumber, true), gettype($cardNumber)), __LINE__);
        }
        $this->cardNumber = $cardNumber;
        return $this;
    }
    /**
     * Get cardZipCode value
     * @return string|null
     */
    public function getCardZipCode()
    {
        return $this->cardZipCode;
    }
    /**
     * Set cardZipCode value
     * @param string $cardZipCode
     * @return \eBizCharge\StructType\CalculateSurchargeAmount
     */
    public function setCardZipCode($cardZipCode = null)
    {
        // validation for constraint: string
        if (!is_null($cardZipCode) && !is_string($cardZipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardZipCode, true), gettype($cardZipCode)), __LINE__);
        }
        $this->cardZipCode = $cardZipCode;
        return $this;
    }
    /**
     * Get customerInternalId value
     * @return string|null
     */
    public function getCustomerInternalId()
    {
        return $this->customerInternalId;
    }
    /**
     * Set customerInternalId value
     * @param string $customerInternalId
     * @return \eBizCharge\StructType\CalculateSurchargeAmount
     */
    public function setCustomerInternalId($customerInternalId = null)
    {
        // validation for constraint: string
        if (!is_null($customerInternalId) && !is_string($customerInternalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerInternalId, true), gettype($customerInternalId)), __LINE__);
        }
        $this->customerInternalId = $customerInternalId;
        return $this;
    }
    /**
     * Get paymentMethodId value
     * @return string|null
     */
    public function getPaymentMethodId()
    {
        return $this->paymentMethodId;
    }
    /**
     * Set paymentMethodId value
     * @param string $paymentMethodId
     * @return \eBizCharge\StructType\CalculateSurchargeAmount
     */
    public function setPaymentMethodId($paymentMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodId) && !is_string($paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodId, true), gettype($paymentMethodId)), __LINE__);
        }
        $this->paymentMethodId = $paymentMethodId;
        return $this;
    }
}
