<?php

namespace eBizCharge\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Login ServiceType
 * @subpackage Services
 */
class Login extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Login
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\Login $parameters
     * @return \eBizCharge\StructType\LoginResponse|bool
     */
    public function Login(\eBizCharge\StructType\Login $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Login($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \eBizCharge\StructType\LoginResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
