<?php

namespace eBizCharge\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSearchFilter ArrayType
 * @subpackage Arrays
 */
class ArrayOfSearchFilter extends AbstractStructArrayBase
{
    /**
     * The SearchFilter
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \eBizCharge\StructType\SearchFilter[]
     */
    public $SearchFilter;
    /**
     * Constructor method for ArrayOfSearchFilter
     * @uses ArrayOfSearchFilter::setSearchFilter()
     * @param \eBizCharge\StructType\SearchFilter[] $searchFilter
     */
    public function __construct(array $searchFilter = array())
    {
        $this
            ->setSearchFilter($searchFilter);
    }
    /**
     * Get SearchFilter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \eBizCharge\StructType\SearchFilter[]|null
     */
    public function getSearchFilter()
    {
        return isset($this->SearchFilter) ? $this->SearchFilter : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSearchFilter method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSearchFilter method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSearchFilterForArrayConstraintsFromSetSearchFilter(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfSearchFilterSearchFilterItem) {
            // validation for constraint: itemType
            if (!$arrayOfSearchFilterSearchFilterItem instanceof \eBizCharge\StructType\SearchFilter) {
                $invalidValues[] = is_object($arrayOfSearchFilterSearchFilterItem) ? get_class($arrayOfSearchFilterSearchFilterItem) : sprintf('%s(%s)', gettype($arrayOfSearchFilterSearchFilterItem), var_export($arrayOfSearchFilterSearchFilterItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SearchFilter property can only contain items of type \eBizCharge\StructType\SearchFilter, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SearchFilter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \eBizCharge\StructType\SearchFilter[] $searchFilter
     * @return \eBizCharge\ArrayType\ArrayOfSearchFilter
     */
    public function setSearchFilter(array $searchFilter = array())
    {
        // validation for constraint: array
        if ('' !== ($searchFilterArrayErrorMessage = self::validateSearchFilterForArrayConstraintsFromSetSearchFilter($searchFilter))) {
            throw new \InvalidArgumentException($searchFilterArrayErrorMessage, __LINE__);
        }
        if (is_null($searchFilter) || (is_array($searchFilter) && empty($searchFilter))) {
            unset($this->SearchFilter);
        } else {
            $this->SearchFilter = $searchFilter;
        }
        return $this;
    }
    /**
     * Add item to SearchFilter value
     * @throws \InvalidArgumentException
     * @param \eBizCharge\StructType\SearchFilter $item
     * @return \eBizCharge\ArrayType\ArrayOfSearchFilter
     */
    public function addToSearchFilter(\eBizCharge\StructType\SearchFilter $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \eBizCharge\StructType\SearchFilter) {
            throw new \InvalidArgumentException(sprintf('The SearchFilter property can only contain items of type \eBizCharge\StructType\SearchFilter, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SearchFilter[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \eBizCharge\StructType\SearchFilter|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \eBizCharge\StructType\SearchFilter|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \eBizCharge\StructType\SearchFilter|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \eBizCharge\StructType\SearchFilter|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \eBizCharge\StructType\SearchFilter|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string SearchFilter
     */
    public function getAttributeName()
    {
        return 'SearchFilter';
    }
}
