<?php

namespace eBizCharge\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfTerms ArrayType
 * @subpackage Arrays
 */
class ArrayOfTerms extends AbstractStructArrayBase
{
    /**
     * The Terms
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \eBizCharge\StructType\Terms[]
     */
    public $Terms;
    /**
     * Constructor method for ArrayOfTerms
     * @uses ArrayOfTerms::setTerms()
     * @param \eBizCharge\StructType\Terms[] $terms
     */
    public function __construct(array $terms = array())
    {
        $this
            ->setTerms($terms);
    }
    /**
     * Get Terms value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \eBizCharge\StructType\Terms[]|null
     */
    public function getTerms()
    {
        return isset($this->Terms) ? $this->Terms : null;
    }
    /**
     * This method is responsible for validating the values passed to the setTerms method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTerms method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTermsForArrayConstraintsFromSetTerms(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfTermsTermsItem) {
            // validation for constraint: itemType
            if (!$arrayOfTermsTermsItem instanceof \eBizCharge\StructType\Terms) {
                $invalidValues[] = is_object($arrayOfTermsTermsItem) ? get_class($arrayOfTermsTermsItem) : sprintf('%s(%s)', gettype($arrayOfTermsTermsItem), var_export($arrayOfTermsTermsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Terms property can only contain items of type \eBizCharge\StructType\Terms, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Terms value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \eBizCharge\StructType\Terms[] $terms
     * @return \eBizCharge\ArrayType\ArrayOfTerms
     */
    public function setTerms(array $terms = array())
    {
        // validation for constraint: array
        if ('' !== ($termsArrayErrorMessage = self::validateTermsForArrayConstraintsFromSetTerms($terms))) {
            throw new \InvalidArgumentException($termsArrayErrorMessage, __LINE__);
        }
        if (is_null($terms) || (is_array($terms) && empty($terms))) {
            unset($this->Terms);
        } else {
            $this->Terms = $terms;
        }
        return $this;
    }
    /**
     * Add item to Terms value
     * @throws \InvalidArgumentException
     * @param \eBizCharge\StructType\Terms $item
     * @return \eBizCharge\ArrayType\ArrayOfTerms
     */
    public function addToTerms(\eBizCharge\StructType\Terms $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \eBizCharge\StructType\Terms) {
            throw new \InvalidArgumentException(sprintf('The Terms property can only contain items of type \eBizCharge\StructType\Terms, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Terms[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \eBizCharge\StructType\Terms|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \eBizCharge\StructType\Terms|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \eBizCharge\StructType\Terms|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \eBizCharge\StructType\Terms|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \eBizCharge\StructType\Terms|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Terms
     */
    public function getAttributeName()
    {
        return 'Terms';
    }
}
