<?php

namespace Iben_station\StationService;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for READ StationService
 * @package Iben_station
 * @subpackage Services
 */
class Iben_stationREAD extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named READ
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Iben_station\StationStruct\Iben_stationREAD $parameters
     * @return \Iben_station\StationStruct\Iben_stationREADResponse|bool
     */
    public function READ(\Iben_station\StationStruct\Iben_stationREAD $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->READ($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Iben_station\StationStruct\Iben_stationREADResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
