<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UploadSignedContract StructType
 * @subpackage Structs
 */
class UploadSignedContract extends AbstractStructBase
{
    /**
     * The credentials
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var Credentials
     */
    public $credentials;
    /**
     * The contract
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var SignedContractData
     */
    public $contract;
    /**
     * Constructor method for UploadSignedContract
     * @uses UploadSignedContract::setCredentials()
     * @uses UploadSignedContract::setContract()
     * @param Credentials $credentials
     * @param SignedContractData $contract
     */
    public function __construct(Credentials $credentials = null, SignedContractData $contract = null)
    {
        $this
            ->setCredentials($credentials)
            ->setContract($contract);
    }
    /**
     * Get credentials value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return Credentials|null
     */
    public function getCredentials()
    {
        return isset($this->credentials) ? $this->credentials : null;
    }
    /**
     * Set credentials value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param Credentials $credentials
     * @return UploadSignedContract
     */
    public function setCredentials(Credentials $credentials = null)
    {
        if (is_null($credentials) || (is_array($credentials) && empty($credentials))) {
            unset($this->credentials);
        } else {
            $this->credentials = $credentials;
        }
        return $this;
    }
    /**
     * Get contract value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return SignedContractData|null
     */
    public function getContract()
    {
        return isset($this->contract) ? $this->contract : null;
    }
    /**
     * Set contract value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param SignedContractData $contract
     * @return UploadSignedContract
     */
    public function setContract(SignedContractData $contract = null)
    {
        if (is_null($contract) || (is_array($contract) && empty($contract))) {
            unset($this->contract);
        } else {
            $this->contract = $contract;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return UploadSignedContract
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
