<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UploadDocument StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:UploadDocument
 * @subpackage Structs
 */
class UploadDocument extends AbstractStructBase
{
    /**
     * The Category
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Category;
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Code;
    /**
     * The Content
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Content;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The IsBioSigned
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsBioSigned;
    /**
     * The SupportingDocumentCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SupportingDocumentCode;
    /**
     * The Guid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Guid;
    /**
     * Constructor method for UploadDocument
     * @uses UploadDocument::setCategory()
     * @uses UploadDocument::setCode()
     * @uses UploadDocument::setContent()
     * @uses UploadDocument::setDescription()
     * @uses UploadDocument::setIsBioSigned()
     * @uses UploadDocument::setSupportingDocumentCode()
     * @uses UploadDocument::setGuid()
     * @param string $category
     * @param string $code
     * @param string $content
     * @param string $description
     * @param bool $isBioSigned
     * @param string $supportingDocumentCode
     * @param string $guid
     */
    public function __construct($category = null, $code = null, $content = null, $description = null, $isBioSigned = null, $supportingDocumentCode = null, $guid = null)
    {
        $this
            ->setCategory($category)
            ->setCode($code)
            ->setContent($content)
            ->setDescription($description)
            ->setIsBioSigned($isBioSigned)
            ->setSupportingDocumentCode($supportingDocumentCode)
            ->setGuid($guid);
    }
    /**
     * Get Category value
     * @return string|null
     */
    public function getCategory()
    {
        return $this->Category;
    }
    /**
     * Set Category value
     * @uses DocumentCategoryEnum::valueIsValid()
     * @uses DocumentCategoryEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $category
     * @return UploadDocument
     */
    public function setCategory($category = null)
    {
        $this->Category = $category;
        return $this;
    }
    /**
     * Get Code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCode()
    {
        return isset($this->Code) ? $this->Code : null;
    }
    /**
     * Set Code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $code
     * @return UploadDocument
     */
    public function setCode($code = null)
    {
        if (is_null($code) || (is_array($code) && empty($code))) {
            unset($this->Code);
        } else {
            $this->Code = $code;
        }
        return $this;
    }
    /**
     * Get Content value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContent()
    {
        return isset($this->Content) ? $this->Content : null;
    }
    /**
     * Set Content value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $content
     * @return UploadDocument
     */
    public function setContent($content = null)
    {
        if (is_null($content) || (is_array($content) && empty($content))) {
            unset($this->Content);
        } else {
            $this->Content = $content;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return UploadDocument
     */
    public function setDescription($description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get IsBioSigned value
     * @return bool|null
     */
    public function getIsBioSigned()
    {
        return $this->IsBioSigned;
    }
    /**
     * Set IsBioSigned value
     * @param bool $isBioSigned
     * @return UploadDocument
     */
    public function setIsBioSigned($isBioSigned = null)
    {
        $this->IsBioSigned = $isBioSigned;
        return $this;
    }
    /**
     * Get SupportingDocumentCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSupportingDocumentCode()
    {
        return isset($this->SupportingDocumentCode) ? $this->SupportingDocumentCode : null;
    }
    /**
     * Set SupportingDocumentCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $supportingDocumentCode
     * @return UploadDocument
     */
    public function setSupportingDocumentCode($supportingDocumentCode = null)
    {
        if (is_null($supportingDocumentCode) || (is_array($supportingDocumentCode) && empty($supportingDocumentCode))) {
            unset($this->SupportingDocumentCode);
        } else {
            $this->SupportingDocumentCode = $supportingDocumentCode;
        }
        return $this;
    }
    /**
     * Get Guid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGuid()
    {
        return isset($this->Guid) ? $this->Guid : null;
    }
    /**
     * Set Guid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $guid
     * @return UploadDocument
     */
    public function setGuid($guid = null)
    {
        if (is_null($guid) || (is_array($guid) && empty($guid))) {
            unset($this->Guid);
        } else {
            $this->Guid = $guid;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return UploadDocument
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
