<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SimulationData StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:SimulationData
 * @subpackage Structs
 */
class SimulationData extends AbstractStructBase
{
    /**
     * The ProductCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProductCode;
    /**
     * The SimulationParameters
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var ArrayOfDataElement
     */
    public $SimulationParameters;
    /**
     * Constructor method for SimulationData
     * @uses SimulationData::setProductCode()
     * @uses SimulationData::setSimulationParameters()
     * @param string $productCode
     * @param ArrayOfDataElement $simulationParameters
     */
    public function __construct($productCode = null, ArrayOfDataElement $simulationParameters = null)
    {
        $this
            ->setProductCode($productCode)
            ->setSimulationParameters($simulationParameters);
    }
    /**
     * Get ProductCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProductCode()
    {
        return isset($this->ProductCode) ? $this->ProductCode : null;
    }
    /**
     * Set ProductCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $productCode
     * @return SimulationData
     */
    public function setProductCode($productCode = null)
    {
        if (is_null($productCode) || (is_array($productCode) && empty($productCode))) {
            unset($this->ProductCode);
        } else {
            $this->ProductCode = $productCode;
        }
        return $this;
    }
    /**
     * Get SimulationParameters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return ArrayOfDataElement|null
     */
    public function getSimulationParameters()
    {
        return isset($this->SimulationParameters) ? $this->SimulationParameters : null;
    }
    /**
     * Set SimulationParameters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param ArrayOfDataElement $simulationParameters
     * @return SimulationData
     */
    public function setSimulationParameters(ArrayOfDataElement $simulationParameters = null)
    {
        if (is_null($simulationParameters) || (is_array($simulationParameters) && empty($simulationParameters))) {
            unset($this->SimulationParameters);
        } else {
            $this->SimulationParameters = $simulationParameters;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return SimulationData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
