<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SimulationAndProposalData StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:SimulationAndProposalData
 * @subpackage Structs
 */
class SimulationAndProposalData extends SimulationData
{
    /**
     * The ContractAction
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ContractAction;
    /**
     * The ProposalData
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var ArrayOfDataElement
     */
    public $ProposalData;
    /**
     * Constructor method for SimulationAndProposalData
     * @uses SimulationAndProposalData::setContractAction()
     * @uses SimulationAndProposalData::setProposalData()
     * @param string $contractAction
     * @param ArrayOfDataElement $proposalData
     */
    public function __construct($contractAction = null, ArrayOfDataElement $proposalData = null)
    {
        $this
            ->setContractAction($contractAction)
            ->setProposalData($proposalData);
    }
    /**
     * Get ContractAction value
     * @return string|null
     */
    public function getContractAction()
    {
        return $this->ContractAction;
    }
    /**
     * Set ContractAction value
     * @uses ContractActionEnum::valueIsValid()
     * @uses ContractActionEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $contractAction
     * @return SimulationAndProposalData
     */
    public function setContractAction($contractAction = null)
    {
        $this->ContractAction = $contractAction;
        return $this;
    }
    /**
     * Get ProposalData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return ArrayOfDataElement|null
     */
    public function getProposalData()
    {
        return isset($this->ProposalData) ? $this->ProposalData : null;
    }
    /**
     * Set ProposalData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param ArrayOfDataElement $proposalData
     * @return SimulationAndProposalData
     */
    public function setProposalData(ArrayOfDataElement $proposalData = null)
    {
        if (is_null($proposalData) || (is_array($proposalData) && empty($proposalData))) {
            unset($this->ProposalData);
        } else {
            $this->ProposalData = $proposalData;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return SimulationAndProposalData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
