<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SignedContractData StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:SignedContractData
 * @subpackage Structs
 */
class SignedContractData extends AbstractStructBase
{
    /**
     * The ContractGuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContractGuid;
    /**
     * The PdfDocuments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var ArrayOfSignedDocument
     */
    public $PdfDocuments;
    /**
     * Constructor method for SignedContractData
     * @uses SignedContractData::setContractGuid()
     * @uses SignedContractData::setPdfDocuments()
     * @param string $contractGuid
     * @param ArrayOfSignedDocument $pdfDocuments
     */
    public function __construct($contractGuid = null, ArrayOfSignedDocument $pdfDocuments = null)
    {
        $this
            ->setContractGuid($contractGuid)
            ->setPdfDocuments($pdfDocuments);
    }
    /**
     * Get ContractGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContractGuid()
    {
        return isset($this->ContractGuid) ? $this->ContractGuid : null;
    }
    /**
     * Set ContractGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contractGuid
     * @return SignedContractData
     */
    public function setContractGuid($contractGuid = null)
    {
        if (is_null($contractGuid) || (is_array($contractGuid) && empty($contractGuid))) {
            unset($this->ContractGuid);
        } else {
            $this->ContractGuid = $contractGuid;
        }
        return $this;
    }
    /**
     * Get PdfDocuments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return ArrayOfSignedDocument|null
     */
    public function getPdfDocuments()
    {
        return isset($this->PdfDocuments) ? $this->PdfDocuments : null;
    }
    /**
     * Set PdfDocuments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param ArrayOfSignedDocument $pdfDocuments
     * @return SignedContractData
     */
    public function setPdfDocuments(ArrayOfSignedDocument $pdfDocuments = null)
    {
        if (is_null($pdfDocuments) || (is_array($pdfDocuments) && empty($pdfDocuments))) {
            unset($this->PdfDocuments);
        } else {
            $this->PdfDocuments = $pdfDocuments;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return SignedContractData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
