<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResultData StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ResultData
 * @subpackage Structs
 */
class ResultData extends AbstractStructBase
{
    /**
     * The ErrorMessages
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var ArrayOfstring
     */
    public $ErrorMessages;
    /**
     * The Result
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Result;
    /**
     * The ResultCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ResultCode;
    /**
     * The WarningMessages
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var ArrayOfstring
     */
    public $WarningMessages;
    /**
     * Constructor method for ResultData
     * @uses ResultData::setErrorMessages()
     * @uses ResultData::setResult()
     * @uses ResultData::setResultCode()
     * @uses ResultData::setWarningMessages()
     * @param ArrayOfstring $errorMessages
     * @param bool $result
     * @param int $resultCode
     * @param ArrayOfstring $warningMessages
     */
    public function __construct(ArrayOfstring $errorMessages = null, $result = null, $resultCode = null, ArrayOfstring $warningMessages = null)
    {
        $this
            ->setErrorMessages($errorMessages)
            ->setResult($result)
            ->setResultCode($resultCode)
            ->setWarningMessages($warningMessages);
    }
    /**
     * Get ErrorMessages value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return ArrayOfstring|null
     */
    public function getErrorMessages()
    {
        return isset($this->ErrorMessages) ? $this->ErrorMessages : null;
    }
    /**
     * Set ErrorMessages value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param ArrayOfstring $errorMessages
     * @return ResultData
     */
    public function setErrorMessages(ArrayOfstring $errorMessages = null)
    {
        if (is_null($errorMessages) || (is_array($errorMessages) && empty($errorMessages))) {
            unset($this->ErrorMessages);
        } else {
            $this->ErrorMessages = $errorMessages;
        }
        return $this;
    }
    /**
     * Get Result value
     * @return bool|null
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param bool $result
     * @return ResultData
     */
    public function setResult($result = null)
    {
        $this->Result = $result;
        return $this;
    }
    /**
     * Get ResultCode value
     * @return int|null
     */
    public function getResultCode()
    {
        return $this->ResultCode;
    }
    /**
     * Set ResultCode value
     * @param int $resultCode
     * @return ResultData
     */
    public function setResultCode($resultCode = null)
    {
        $this->ResultCode = $resultCode;
        return $this;
    }
    /**
     * Get WarningMessages value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return ArrayOfstring|null
     */
    public function getWarningMessages()
    {
        return isset($this->WarningMessages) ? $this->WarningMessages : null;
    }
    /**
     * Set WarningMessages value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param ArrayOfstring $warningMessages
     * @return ResultData
     */
    public function setWarningMessages(ArrayOfstring $warningMessages = null)
    {
        if (is_null($warningMessages) || (is_array($warningMessages) && empty($warningMessages))) {
            unset($this->WarningMessages);
        } else {
            $this->WarningMessages = $warningMessages;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return ResultData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
