<?php
/**
 * This class stands for HolderTypeEnum EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:HolderTypeEnum
 * @subpackage Enumerations
 */
class HolderTypeEnum
{
    /**
     * Constant for value 'Unknown'
     * @return string 'Unknown'
     */
    const ENUM_VALUE_0 = 'Unknown';
    /**
     * Constant for value 'Person'
     * @return string 'Person'
     */
    const ENUM_VALUE_1 = 'Person';
    /**
     * Constant for value 'Corporation'
     * @return string 'Corporation'
     */
    const ENUM_VALUE_2 = 'Corporation';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::ENUM_VALUE_0
     * @uses self::ENUM_VALUE_1
     * @uses self::ENUM_VALUE_2
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::ENUM_VALUE_0,
            self::ENUM_VALUE_1,
            self::ENUM_VALUE_2,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
