<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Holder StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Holder
 * @subpackage Structs
 */
class Holder extends PolicyHolder
{
    /**
     * The HolderContactOmitted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $HolderContactOmitted;
    /**
     * The HolderType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $HolderType;
    /**
     * The Identification
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Identification;
    /**
     * The IndentificationType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $IndentificationType;
    /**
     * Constructor method for Holder
     * @uses Holder::setHolderContactOmitted()
     * @uses Holder::setHolderType()
     * @uses Holder::setIdentification()
     * @uses Holder::setIndentificationType()
     * @param bool $holderContactOmitted
     * @param string $holderType
     * @param string $identification
     * @param string $indentificationType
     */
    public function __construct($holderContactOmitted = null, $holderType = null, $identification = null, $indentificationType = null)
    {
        $this
            ->setHolderContactOmitted($holderContactOmitted)
            ->setHolderType($holderType)
            ->setIdentification($identification)
            ->setIndentificationType($indentificationType);
    }
    /**
     * Get HolderContactOmitted value
     * @return bool|null
     */
    public function getHolderContactOmitted()
    {
        return $this->HolderContactOmitted;
    }
    /**
     * Set HolderContactOmitted value
     * @param bool $holderContactOmitted
     * @return Holder
     */
    public function setHolderContactOmitted($holderContactOmitted = null)
    {
        $this->HolderContactOmitted = $holderContactOmitted;
        return $this;
    }
    /**
     * Get HolderType value
     * @return string|null
     */
    public function getHolderType()
    {
        return $this->HolderType;
    }
    /**
     * Set HolderType value
     * @uses HolderTypeEnum::valueIsValid()
     * @uses HolderTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $holderType
     * @return Holder
     */
    public function setHolderType($holderType = null)
    {
        $this->HolderType = $holderType;
        return $this;
    }
    /**
     * Get Identification value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdentification()
    {
        return isset($this->Identification) ? $this->Identification : null;
    }
    /**
     * Set Identification value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $identification
     * @return Holder
     */
    public function setIdentification($identification = null)
    {
        if (is_null($identification) || (is_array($identification) && empty($identification))) {
            unset($this->Identification);
        } else {
            $this->Identification = $identification;
        }
        return $this;
    }
    /**
     * Get IndentificationType value
     * @return string|null
     */
    public function getIndentificationType()
    {
        return $this->IndentificationType;
    }
    /**
     * Set IndentificationType value
     * @uses IdentificationTypeEnum::valueIsValid()
     * @uses IdentificationTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $indentificationType
     * @return Holder
     */
    public function setIndentificationType($indentificationType = null)
    {
        $this->IndentificationType = $indentificationType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return Holder
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
