<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetContractInfo StructType
 * @subpackage Structs
 */
class GetContractInfo extends AbstractStructBase
{
    /**
     * The credentials
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var Credentials
     */
    public $credentials;
    /**
     * The contractIdentifier
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $contractIdentifier;
    /**
     * Constructor method for GetContractInfo
     * @uses GetContractInfo::setCredentials()
     * @uses GetContractInfo::setContractIdentifier()
     * @param Credentials $credentials
     * @param string $contractIdentifier
     */
    public function __construct(Credentials $credentials = null, $contractIdentifier = null)
    {
        $this
            ->setCredentials($credentials)
            ->setContractIdentifier($contractIdentifier);
    }
    /**
     * Get credentials value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return Credentials|null
     */
    public function getCredentials()
    {
        return isset($this->credentials) ? $this->credentials : null;
    }
    /**
     * Set credentials value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param Credentials $credentials
     * @return GetContractInfo
     */
    public function setCredentials(Credentials $credentials = null)
    {
        if (is_null($credentials) || (is_array($credentials) && empty($credentials))) {
            unset($this->credentials);
        } else {
            $this->credentials = $credentials;
        }
        return $this;
    }
    /**
     * Get contractIdentifier value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContractIdentifier()
    {
        return isset($this->contractIdentifier) ? $this->contractIdentifier : null;
    }
    /**
     * Set contractIdentifier value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contractIdentifier
     * @return GetContractInfo
     */
    public function setContractIdentifier($contractIdentifier = null)
    {
        if (is_null($contractIdentifier) || (is_array($contractIdentifier) && empty($contractIdentifier))) {
            unset($this->contractIdentifier);
        } else {
            $this->contractIdentifier = $contractIdentifier;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return GetContractInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
