<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetContractDocuments StructType
 * @subpackage Structs
 */
class GetContractDocuments extends AbstractStructBase
{
    /**
     * The credentials
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var Credentials
     */
    public $credentials;
    /**
     * The contractId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $contractId;
    /**
     * Constructor method for GetContractDocuments
     * @uses GetContractDocuments::setCredentials()
     * @uses GetContractDocuments::setContractId()
     * @param Credentials $credentials
     * @param string $contractId
     */
    public function __construct(Credentials $credentials = null, $contractId = null)
    {
        $this
            ->setCredentials($credentials)
            ->setContractId($contractId);
    }
    /**
     * Get credentials value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return Credentials|null
     */
    public function getCredentials()
    {
        return isset($this->credentials) ? $this->credentials : null;
    }
    /**
     * Set credentials value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param Credentials $credentials
     * @return GetContractDocuments
     */
    public function setCredentials(Credentials $credentials = null)
    {
        if (is_null($credentials) || (is_array($credentials) && empty($credentials))) {
            unset($this->credentials);
        } else {
            $this->credentials = $credentials;
        }
        return $this;
    }
    /**
     * Get contractId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContractId()
    {
        return isset($this->contractId) ? $this->contractId : null;
    }
    /**
     * Set contractId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contractId
     * @return GetContractDocuments
     */
    public function setContractId($contractId = null)
    {
        if (is_null($contractId) || (is_array($contractId) && empty($contractId))) {
            unset($this->contractId);
        } else {
            $this->contractId = $contractId;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return GetContractDocuments
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
