<?php
use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetContractDocuments
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetContractDocuments $parameters
     * @return GetContractDocumentsResponse|bool
     */
    public function GetContractDocuments(GetContractDocuments $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetContractDocuments($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetProductList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetProductList $parameters
     * @return GetProductListResponse|bool
     */
    public function GetProductList(GetProductList $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetProductList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCodeLists
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetCodeLists $parameters
     * @return GetCodeListsResponse|bool
     */
    public function GetCodeLists(GetCodeLists $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCodeLists($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCodeListItems
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetCodeListItems $parameters
     * @return GetCodeListItemsResponse|bool
     */
    public function GetCodeListItems(GetCodeListItems $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCodeListItems($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetItemsDefinition
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetItemsDefinition $parameters
     * @return GetItemsDefinitionResponse|bool
     */
    public function GetItemsDefinition(GetItemsDefinition $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetItemsDefinition($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetContractsInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetContractsInfo $parameters
     * @return GetContractsInfoResponse|bool
     */
    public function GetContractsInfo(GetContractsInfo $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetContractsInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetContractInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetContractInfo $parameters
     * @return GetContractInfoResponse|bool
     */
    public function GetContractInfo(GetContractInfo $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetContractInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return GetCodeListItemsResponse|GetCodeListsResponse|GetContractDocumentsResponse|GetContractInfoResponse|GetContractsInfoResponse|GetItemsDefinitionResponse|GetProductListResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
