<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DataElement StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:DataElement
 * @subpackage Structs
 */
class DataElement extends AbstractStructBase
{
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The SubElements
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var ArrayOfDataElement
     */
    public $SubElements;
    /**
     * The Value
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Value;
    /**
     * Constructor method for DataElement
     * @uses DataElement::setName()
     * @uses DataElement::setSubElements()
     * @uses DataElement::setValue()
     * @param string $name
     * @param ArrayOfDataElement $subElements
     * @param string $value
     */
    public function __construct($name = null, ArrayOfDataElement $subElements = null, $value = null)
    {
        $this
            ->setName($name)
            ->setSubElements($subElements)
            ->setValue($value);
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return DataElement
     */
    public function setName($name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get SubElements value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return ArrayOfDataElement|null
     */
    public function getSubElements()
    {
        return isset($this->SubElements) ? $this->SubElements : null;
    }
    /**
     * Set SubElements value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param ArrayOfDataElement $subElements
     * @return DataElement
     */
    public function setSubElements(ArrayOfDataElement $subElements = null)
    {
        if (is_null($subElements) || (is_array($subElements) && empty($subElements))) {
            unset($this->SubElements);
        } else {
            $this->SubElements = $subElements;
        }
        return $this;
    }
    /**
     * Get Value value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValue()
    {
        return isset($this->Value) ? $this->Value : null;
    }
    /**
     * Set Value value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $value
     * @return DataElement
     */
    public function setValue($value = null)
    {
        if (is_null($value) || (is_array($value) && empty($value))) {
            unset($this->Value);
        } else {
            $this->Value = $value;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return DataElement
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
