<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Credentials StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Credentials
 * @subpackage Structs
 */
class Credentials extends AbstractStructBase
{
    /**
     * The AgentId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AgentId;
    /**
     * The AlternativeBrokerId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AlternativeBrokerId;
    /**
     * The BrokerCountry
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $BrokerCountry;
    /**
     * The BrokerId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $BrokerId;
    /**
     * The Password
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Password;
    /**
     * Constructor method for Credentials
     * @uses Credentials::setAgentId()
     * @uses Credentials::setAlternativeBrokerId()
     * @uses Credentials::setBrokerCountry()
     * @uses Credentials::setBrokerId()
     * @uses Credentials::setPassword()
     * @param string $agentId
     * @param string $alternativeBrokerId
     * @param string $brokerCountry
     * @param int $brokerId
     * @param string $password
     */
    public function __construct($agentId = null, $alternativeBrokerId = null, $brokerCountry = null, $brokerId = null, $password = null)
    {
        $this
            ->setAgentId($agentId)
            ->setAlternativeBrokerId($alternativeBrokerId)
            ->setBrokerCountry($brokerCountry)
            ->setBrokerId($brokerId)
            ->setPassword($password);
    }
    /**
     * Get AgentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAgentId()
    {
        return isset($this->AgentId) ? $this->AgentId : null;
    }
    /**
     * Set AgentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $agentId
     * @return Credentials
     */
    public function setAgentId($agentId = null)
    {
        if (is_null($agentId) || (is_array($agentId) && empty($agentId))) {
            unset($this->AgentId);
        } else {
            $this->AgentId = $agentId;
        }
        return $this;
    }
    /**
     * Get AlternativeBrokerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAlternativeBrokerId()
    {
        return isset($this->AlternativeBrokerId) ? $this->AlternativeBrokerId : null;
    }
    /**
     * Set AlternativeBrokerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $alternativeBrokerId
     * @return Credentials
     */
    public function setAlternativeBrokerId($alternativeBrokerId = null)
    {
        if (is_null($alternativeBrokerId) || (is_array($alternativeBrokerId) && empty($alternativeBrokerId))) {
            unset($this->AlternativeBrokerId);
        } else {
            $this->AlternativeBrokerId = $alternativeBrokerId;
        }
        return $this;
    }
    /**
     * Get BrokerCountry value
     * @return string|null
     */
    public function getBrokerCountry()
    {
        return $this->BrokerCountry;
    }
    /**
     * Set BrokerCountry value
     * @uses BrokerCountryEnum::valueIsValid()
     * @uses BrokerCountryEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $brokerCountry
     * @return Credentials
     */
    public function setBrokerCountry($brokerCountry = null)
    {
        $this->BrokerCountry = $brokerCountry;
        return $this;
    }
    /**
     * Get BrokerId value
     * @return int|null
     */
    public function getBrokerId()
    {
        return $this->BrokerId;
    }
    /**
     * Set BrokerId value
     * @param int $brokerId
     * @return Credentials
     */
    public function setBrokerId($brokerId = null)
    {
        $this->BrokerId = $brokerId;
        return $this;
    }
    /**
     * Get Password value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPassword()
    {
        return isset($this->Password) ? $this->Password : null;
    }
    /**
     * Set Password value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $password
     * @return Credentials
     */
    public function setPassword($password = null)
    {
        if (is_null($password) || (is_array($password) && empty($password))) {
            unset($this->Password);
        } else {
            $this->Password = $password;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return Credentials
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
