<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContractsFilter StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ContractsFilter
 * @subpackage Structs
 */
class ContractsFilter extends AbstractStructBase
{
    /**
     * The ProductCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProductCode;
    /**
     * The From
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $From;
    /**
     * The EventType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventType;
    /**
     * The AgentId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AgentId;
    /**
     * The ContractPortalEnum
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContractPortalEnum;
    /**
     * Constructor method for ContractsFilter
     * @uses ContractsFilter::setProductCode()
     * @uses ContractsFilter::setFrom()
     * @uses ContractsFilter::setEventType()
     * @uses ContractsFilter::setAgentId()
     * @uses ContractsFilter::setContractPortalEnum()
     * @param string $productCode
     * @param string $from
     * @param string $eventType
     * @param string $agentId
     * @param string $contractPortalEnum
     */
    public function __construct($productCode = null, $from = null, $eventType = null, $agentId = null, $contractPortalEnum = null)
    {
        $this
            ->setProductCode($productCode)
            ->setFrom($from)
            ->setEventType($eventType)
            ->setAgentId($agentId)
            ->setContractPortalEnum($contractPortalEnum);
    }
    /**
     * Get ProductCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProductCode()
    {
        return isset($this->ProductCode) ? $this->ProductCode : null;
    }
    /**
     * Set ProductCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $productCode
     * @return ContractsFilter
     */
    public function setProductCode($productCode = null)
    {
        if (is_null($productCode) || (is_array($productCode) && empty($productCode))) {
            unset($this->ProductCode);
        } else {
            $this->ProductCode = $productCode;
        }
        return $this;
    }
    /**
     * Get From value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFrom()
    {
        return isset($this->From) ? $this->From : null;
    }
    /**
     * Set From value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $from
     * @return ContractsFilter
     */
    public function setFrom($from = null)
    {
        if (is_null($from) || (is_array($from) && empty($from))) {
            unset($this->From);
        } else {
            $this->From = $from;
        }
        return $this;
    }
    /**
     * Get EventType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventType()
    {
        return isset($this->EventType) ? $this->EventType : null;
    }
    /**
     * Set EventType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses EventTypeExternal::valueIsValid()
     * @uses EventTypeExternal::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $eventType
     * @return ContractsFilter
     */
    public function setEventType($eventType = null)
    {
        if (is_null($eventType) || (is_array($eventType) && empty($eventType))) {
            unset($this->EventType);
        } else {
            $this->EventType = $eventType;
        }
        return $this;
    }
    /**
     * Get AgentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAgentId()
    {
        return isset($this->AgentId) ? $this->AgentId : null;
    }
    /**
     * Set AgentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $agentId
     * @return ContractsFilter
     */
    public function setAgentId($agentId = null)
    {
        if (is_null($agentId) || (is_array($agentId) && empty($agentId))) {
            unset($this->AgentId);
        } else {
            $this->AgentId = $agentId;
        }
        return $this;
    }
    /**
     * Get ContractPortalEnum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContractPortalEnum()
    {
        return isset($this->ContractPortalEnum) ? $this->ContractPortalEnum : null;
    }
    /**
     * Set ContractPortalEnum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses ContractPortalEnum::valueIsValid()
     * @uses ContractPortalEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $contractPortalEnum
     * @return ContractsFilter
     */
    public function setContractPortalEnum($contractPortalEnum = null)
    {
        if (is_null($contractPortalEnum) || (is_array($contractPortalEnum) && empty($contractPortalEnum))) {
            unset($this->ContractPortalEnum);
        } else {
            $this->ContractPortalEnum = $contractPortalEnum;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return ContractsFilter
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
