<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContractResult StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ContractResult
 * @subpackage Structs
 */
class ContractResult extends SimulationResult
{
    /**
     * The Documents
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var Documents
     */
    public $Documents;
    /**
     * The IdOfContract
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IdOfContract;
    /**
     * The ProposalNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ProposalNumber;
    /**
     * The GeneralContractXml
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $GeneralContractXml;
    /**
     * Constructor method for ContractResult
     * @uses ContractResult::setDocuments()
     * @uses ContractResult::setIdOfContract()
     * @uses ContractResult::setProposalNumber()
     * @uses ContractResult::setGeneralContractXml()
     * @param Documents $documents
     * @param string $idOfContract
     * @param int $proposalNumber
     * @param string $generalContractXml
     */
    public function __construct(Documents $documents = null, $idOfContract = null, $proposalNumber = null, $generalContractXml = null)
    {
        $this
            ->setDocuments($documents)
            ->setIdOfContract($idOfContract)
            ->setProposalNumber($proposalNumber)
            ->setGeneralContractXml($generalContractXml);
    }
    /**
     * Get Documents value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return Documents|null
     */
    public function getDocuments()
    {
        return isset($this->Documents) ? $this->Documents : null;
    }
    /**
     * Set Documents value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param Documents $documents
     * @return ContractResult
     */
    public function setDocuments(Documents $documents = null)
    {
        if (is_null($documents) || (is_array($documents) && empty($documents))) {
            unset($this->Documents);
        } else {
            $this->Documents = $documents;
        }
        return $this;
    }
    /**
     * Get IdOfContract value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdOfContract()
    {
        return isset($this->IdOfContract) ? $this->IdOfContract : null;
    }
    /**
     * Set IdOfContract value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idOfContract
     * @return ContractResult
     */
    public function setIdOfContract($idOfContract = null)
    {
        if (is_null($idOfContract) || (is_array($idOfContract) && empty($idOfContract))) {
            unset($this->IdOfContract);
        } else {
            $this->IdOfContract = $idOfContract;
        }
        return $this;
    }
    /**
     * Get ProposalNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getProposalNumber()
    {
        return isset($this->ProposalNumber) ? $this->ProposalNumber : null;
    }
    /**
     * Set ProposalNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $proposalNumber
     * @return ContractResult
     */
    public function setProposalNumber($proposalNumber = null)
    {
        if (is_null($proposalNumber) || (is_array($proposalNumber) && empty($proposalNumber))) {
            unset($this->ProposalNumber);
        } else {
            $this->ProposalNumber = $proposalNumber;
        }
        return $this;
    }
    /**
     * Get GeneralContractXml value
     * @return string|null
     */
    public function getGeneralContractXml()
    {
        return $this->GeneralContractXml;
    }
    /**
     * Set GeneralContractXml value
     * @param string $generalContractXml
     * @return ContractResult
     */
    public function setGeneralContractXml($generalContractXml = null)
    {
        $this->GeneralContractXml = $generalContractXml;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return ContractResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
