<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContractInfo StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ContractInfo
 * @subpackage Structs
 */
class ContractInfo extends AbstractStructBase
{
    /**
     * The ProposalNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ProposalNumber;
    /**
     * The ContractId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContractId;
    /**
     * The Created
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Created;
    /**
     * The Events
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var ArrayOfContractEvent
     */
    public $Events;
    /**
     * The GeneralXml
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GeneralXml;
    /**
     * The ProductCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProductCode;
    /**
     * Constructor method for ContractInfo
     * @uses ContractInfo::setProposalNumber()
     * @uses ContractInfo::setContractId()
     * @uses ContractInfo::setCreated()
     * @uses ContractInfo::setEvents()
     * @uses ContractInfo::setGeneralXml()
     * @uses ContractInfo::setProductCode()
     * @param int $proposalNumber
     * @param string $contractId
     * @param string $created
     * @param ArrayOfContractEvent $events
     * @param string $generalXml
     * @param string $productCode
     */
    public function __construct($proposalNumber = null, $contractId = null, $created = null, ArrayOfContractEvent $events = null, $generalXml = null, $productCode = null)
    {
        $this
            ->setProposalNumber($proposalNumber)
            ->setContractId($contractId)
            ->setCreated($created)
            ->setEvents($events)
            ->setGeneralXml($generalXml)
            ->setProductCode($productCode);
    }
    /**
     * Get ProposalNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getProposalNumber()
    {
        return isset($this->ProposalNumber) ? $this->ProposalNumber : null;
    }
    /**
     * Set ProposalNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $proposalNumber
     * @return ContractInfo
     */
    public function setProposalNumber($proposalNumber = null)
    {
        if (is_null($proposalNumber) || (is_array($proposalNumber) && empty($proposalNumber))) {
            unset($this->ProposalNumber);
        } else {
            $this->ProposalNumber = $proposalNumber;
        }
        return $this;
    }
    /**
     * Get ContractId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContractId()
    {
        return isset($this->ContractId) ? $this->ContractId : null;
    }
    /**
     * Set ContractId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contractId
     * @return ContractInfo
     */
    public function setContractId($contractId = null)
    {
        if (is_null($contractId) || (is_array($contractId) && empty($contractId))) {
            unset($this->ContractId);
        } else {
            $this->ContractId = $contractId;
        }
        return $this;
    }
    /**
     * Get Created value
     * @return string|null
     */
    public function getCreated()
    {
        return $this->Created;
    }
    /**
     * Set Created value
     * @param string $created
     * @return ContractInfo
     */
    public function setCreated($created = null)
    {
        $this->Created = $created;
        return $this;
    }
    /**
     * Get Events value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return ArrayOfContractEvent|null
     */
    public function getEvents()
    {
        return isset($this->Events) ? $this->Events : null;
    }
    /**
     * Set Events value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param ArrayOfContractEvent $events
     * @return ContractInfo
     */
    public function setEvents(ArrayOfContractEvent $events = null)
    {
        if (is_null($events) || (is_array($events) && empty($events))) {
            unset($this->Events);
        } else {
            $this->Events = $events;
        }
        return $this;
    }
    /**
     * Get GeneralXml value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGeneralXml()
    {
        return isset($this->GeneralXml) ? $this->GeneralXml : null;
    }
    /**
     * Set GeneralXml value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $generalXml
     * @return ContractInfo
     */
    public function setGeneralXml($generalXml = null)
    {
        if (is_null($generalXml) || (is_array($generalXml) && empty($generalXml))) {
            unset($this->GeneralXml);
        } else {
            $this->GeneralXml = $generalXml;
        }
        return $this;
    }
    /**
     * Get ProductCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProductCode()
    {
        return isset($this->ProductCode) ? $this->ProductCode : null;
    }
    /**
     * Set ProductCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $productCode
     * @return ContractInfo
     */
    public function setProductCode($productCode = null)
    {
        if (is_null($productCode) || (is_array($productCode) && empty($productCode))) {
            unset($this->ProductCode);
        } else {
            $this->ProductCode = $productCode;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return ContractInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
