<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContractData StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ContractData
 * @subpackage Structs
 */
class ContractData extends AbstractStructBase
{
    /**
     * The AdditionalAction
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AdditionalAction;
    /**
     * The Agent
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var Agent
     */
    public $Agent;
    /**
     * The Beginning
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Beginning;
    /**
     * The CoverProposalNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CoverProposalNumber;
    /**
     * The Created
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Created;
    /**
     * The Data
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Data;
    /**
     * The Documents
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var ArrayOfUploadDocument
     */
    public $Documents;
    /**
     * The IdOfSignedContract
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IdOfSignedContract;
    /**
     * The PolicyHolder
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var Holder
     */
    public $PolicyHolder;
    /**
     * The ProductCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProductCode;
    /**
     * The ProposalNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ProposalNumber;
    /**
     * The RegistrationAction
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RegistrationAction;
    /**
     * The Signed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Signed;
    /**
     * The GeneralXml
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GeneralXml;
    /**
     * Constructor method for ContractData
     * @uses ContractData::setAdditionalAction()
     * @uses ContractData::setAgent()
     * @uses ContractData::setBeginning()
     * @uses ContractData::setCoverProposalNumber()
     * @uses ContractData::setCreated()
     * @uses ContractData::setData()
     * @uses ContractData::setDocuments()
     * @uses ContractData::setIdOfSignedContract()
     * @uses ContractData::setPolicyHolder()
     * @uses ContractData::setProductCode()
     * @uses ContractData::setProposalNumber()
     * @uses ContractData::setRegistrationAction()
     * @uses ContractData::setSigned()
     * @uses ContractData::setGeneralXml()
     * @param string $additionalAction
     * @param Agent $agent
     * @param string $beginning
     * @param int $coverProposalNumber
     * @param string $created
     * @param string $data
     * @param ArrayOfUploadDocument $documents
     * @param string $idOfSignedContract
     * @param Holder $policyHolder
     * @param string $productCode
     * @param int $proposalNumber
     * @param string $registrationAction
     * @param string $signed
     * @param string $generalXml
     */
    public function __construct($additionalAction = null, Agent $agent = null, $beginning = null, $coverProposalNumber = null, $created = null, $data = null, ArrayOfUploadDocument $documents = null, $idOfSignedContract = null, Holder $policyHolder = null, $productCode = null, $proposalNumber = null, $registrationAction = null, $signed = null, $generalXml = null)
    {
        $this
            ->setAdditionalAction($additionalAction)
            ->setAgent($agent)
            ->setBeginning($beginning)
            ->setCoverProposalNumber($coverProposalNumber)
            ->setCreated($created)
            ->setData($data)
            ->setDocuments($documents)
            ->setIdOfSignedContract($idOfSignedContract)
            ->setPolicyHolder($policyHolder)
            ->setProductCode($productCode)
            ->setProposalNumber($proposalNumber)
            ->setRegistrationAction($registrationAction)
            ->setSigned($signed)
            ->setGeneralXml($generalXml);
    }
    /**
     * Get AdditionalAction value
     * @return string|null
     */
    public function getAdditionalAction()
    {
        return $this->AdditionalAction;
    }
    /**
     * Set AdditionalAction value
     * @uses AdditionalActionEnum::valueIsValid()
     * @uses AdditionalActionEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $additionalAction
     * @return ContractData
     */
    public function setAdditionalAction($additionalAction = null)
    {
        $this->AdditionalAction = $additionalAction;
        return $this;
    }
    /**
     * Get Agent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return Agent|null
     */
    public function getAgent()
    {
        return isset($this->Agent) ? $this->Agent : null;
    }
    /**
     * Set Agent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param Agent $agent
     * @return ContractData
     */
    public function setAgent(Agent $agent = null)
    {
        if (is_null($agent) || (is_array($agent) && empty($agent))) {
            unset($this->Agent);
        } else {
            $this->Agent = $agent;
        }
        return $this;
    }
    /**
     * Get Beginning value
     * @return string|null
     */
    public function getBeginning()
    {
        return $this->Beginning;
    }
    /**
     * Set Beginning value
     * @param string $beginning
     * @return ContractData
     */
    public function setBeginning($beginning = null)
    {
        $this->Beginning = $beginning;
        return $this;
    }
    /**
     * Get CoverProposalNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCoverProposalNumber()
    {
        return isset($this->CoverProposalNumber) ? $this->CoverProposalNumber : null;
    }
    /**
     * Set CoverProposalNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $coverProposalNumber
     * @return ContractData
     */
    public function setCoverProposalNumber($coverProposalNumber = null)
    {
        if (is_null($coverProposalNumber) || (is_array($coverProposalNumber) && empty($coverProposalNumber))) {
            unset($this->CoverProposalNumber);
        } else {
            $this->CoverProposalNumber = $coverProposalNumber;
        }
        return $this;
    }
    /**
     * Get Created value
     * @return string|null
     */
    public function getCreated()
    {
        return $this->Created;
    }
    /**
     * Set Created value
     * @param string $created
     * @return ContractData
     */
    public function setCreated($created = null)
    {
        $this->Created = $created;
        return $this;
    }
    /**
     * Get Data value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getData()
    {
        return isset($this->Data) ? $this->Data : null;
    }
    /**
     * Set Data value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $data
     * @return ContractData
     */
    public function setData($data = null)
    {
        if (is_null($data) || (is_array($data) && empty($data))) {
            unset($this->Data);
        } else {
            $this->Data = $data;
        }
        return $this;
    }
    /**
     * Get Documents value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return ArrayOfUploadDocument|null
     */
    public function getDocuments()
    {
        return isset($this->Documents) ? $this->Documents : null;
    }
    /**
     * Set Documents value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param ArrayOfUploadDocument $documents
     * @return ContractData
     */
    public function setDocuments(ArrayOfUploadDocument $documents = null)
    {
        if (is_null($documents) || (is_array($documents) && empty($documents))) {
            unset($this->Documents);
        } else {
            $this->Documents = $documents;
        }
        return $this;
    }
    /**
     * Get IdOfSignedContract value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdOfSignedContract()
    {
        return isset($this->IdOfSignedContract) ? $this->IdOfSignedContract : null;
    }
    /**
     * Set IdOfSignedContract value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idOfSignedContract
     * @return ContractData
     */
    public function setIdOfSignedContract($idOfSignedContract = null)
    {
        if (is_null($idOfSignedContract) || (is_array($idOfSignedContract) && empty($idOfSignedContract))) {
            unset($this->IdOfSignedContract);
        } else {
            $this->IdOfSignedContract = $idOfSignedContract;
        }
        return $this;
    }
    /**
     * Get PolicyHolder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return Holder|null
     */
    public function getPolicyHolder()
    {
        return isset($this->PolicyHolder) ? $this->PolicyHolder : null;
    }
    /**
     * Set PolicyHolder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param Holder $policyHolder
     * @return ContractData
     */
    public function setPolicyHolder(Holder $policyHolder = null)
    {
        if (is_null($policyHolder) || (is_array($policyHolder) && empty($policyHolder))) {
            unset($this->PolicyHolder);
        } else {
            $this->PolicyHolder = $policyHolder;
        }
        return $this;
    }
    /**
     * Get ProductCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProductCode()
    {
        return isset($this->ProductCode) ? $this->ProductCode : null;
    }
    /**
     * Set ProductCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $productCode
     * @return ContractData
     */
    public function setProductCode($productCode = null)
    {
        if (is_null($productCode) || (is_array($productCode) && empty($productCode))) {
            unset($this->ProductCode);
        } else {
            $this->ProductCode = $productCode;
        }
        return $this;
    }
    /**
     * Get ProposalNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getProposalNumber()
    {
        return isset($this->ProposalNumber) ? $this->ProposalNumber : null;
    }
    /**
     * Set ProposalNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $proposalNumber
     * @return ContractData
     */
    public function setProposalNumber($proposalNumber = null)
    {
        if (is_null($proposalNumber) || (is_array($proposalNumber) && empty($proposalNumber))) {
            unset($this->ProposalNumber);
        } else {
            $this->ProposalNumber = $proposalNumber;
        }
        return $this;
    }
    /**
     * Get RegistrationAction value
     * @return string|null
     */
    public function getRegistrationAction()
    {
        return $this->RegistrationAction;
    }
    /**
     * Set RegistrationAction value
     * @uses RegistrationActionEnum::valueIsValid()
     * @uses RegistrationActionEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $registrationAction
     * @return ContractData
     */
    public function setRegistrationAction($registrationAction = null)
    {
        $this->RegistrationAction = $registrationAction;
        return $this;
    }
    /**
     * Get Signed value
     * @return string|null
     */
    public function getSigned()
    {
        return $this->Signed;
    }
    /**
     * Set Signed value
     * @param string $signed
     * @return ContractData
     */
    public function setSigned($signed = null)
    {
        $this->Signed = $signed;
        return $this;
    }
    /**
     * Get GeneralXml value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGeneralXml()
    {
        return isset($this->GeneralXml) ? $this->GeneralXml : null;
    }
    /**
     * Set GeneralXml value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $generalXml
     * @return ContractData
     */
    public function setGeneralXml($generalXml = null)
    {
        if (is_null($generalXml) || (is_array($generalXml) && empty($generalXml))) {
            unset($this->GeneralXml);
        } else {
            $this->GeneralXml = $generalXml;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return ContractData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
