<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContractChangedData StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ContractChangedData
 * @subpackage Structs
 */
class ContractChangedData extends AbstractStructBase
{
    /**
     * The ContractId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContractId;
    /**
     * The ProposalData
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var ArrayOfDataElement
     */
    public $ProposalData;
    /**
     * Constructor method for ContractChangedData
     * @uses ContractChangedData::setContractId()
     * @uses ContractChangedData::setProposalData()
     * @param string $contractId
     * @param ArrayOfDataElement $proposalData
     */
    public function __construct($contractId = null, ArrayOfDataElement $proposalData = null)
    {
        $this
            ->setContractId($contractId)
            ->setProposalData($proposalData);
    }
    /**
     * Get ContractId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContractId()
    {
        return isset($this->ContractId) ? $this->ContractId : null;
    }
    /**
     * Set ContractId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contractId
     * @return ContractChangedData
     */
    public function setContractId($contractId = null)
    {
        if (is_null($contractId) || (is_array($contractId) && empty($contractId))) {
            unset($this->ContractId);
        } else {
            $this->ContractId = $contractId;
        }
        return $this;
    }
    /**
     * Get ProposalData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return ArrayOfDataElement|null
     */
    public function getProposalData()
    {
        return isset($this->ProposalData) ? $this->ProposalData : null;
    }
    /**
     * Set ProposalData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param ArrayOfDataElement $proposalData
     * @return ContractChangedData
     */
    public function setProposalData(ArrayOfDataElement $proposalData = null)
    {
        if (is_null($proposalData) || (is_array($proposalData) && empty($proposalData))) {
            unset($this->ProposalData);
        } else {
            $this->ProposalData = $proposalData;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return ContractChangedData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
