<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChangeContract StructType
 * @subpackage Structs
 */
class ChangeContract extends AbstractStructBase
{
    /**
     * The credentials
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var Credentials
     */
    public $credentials;
    /**
     * The changes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var ContractChangedData
     */
    public $changes;
    /**
     * Constructor method for ChangeContract
     * @uses ChangeContract::setCredentials()
     * @uses ChangeContract::setChanges()
     * @param Credentials $credentials
     * @param ContractChangedData $changes
     */
    public function __construct(Credentials $credentials = null, ContractChangedData $changes = null)
    {
        $this
            ->setCredentials($credentials)
            ->setChanges($changes);
    }
    /**
     * Get credentials value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return Credentials|null
     */
    public function getCredentials()
    {
        return isset($this->credentials) ? $this->credentials : null;
    }
    /**
     * Set credentials value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param Credentials $credentials
     * @return ChangeContract
     */
    public function setCredentials(Credentials $credentials = null)
    {
        if (is_null($credentials) || (is_array($credentials) && empty($credentials))) {
            unset($this->credentials);
        } else {
            $this->credentials = $credentials;
        }
        return $this;
    }
    /**
     * Get changes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return ContractChangedData|null
     */
    public function getChanges()
    {
        return isset($this->changes) ? $this->changes : null;
    }
    /**
     * Set changes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param ContractChangedData $changes
     * @return ChangeContract
     */
    public function setChanges(ContractChangedData $changes = null)
    {
        if (is_null($changes) || (is_array($changes) && empty($changes))) {
            unset($this->changes);
        } else {
            $this->changes = $changes;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return ChangeContract
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
