<?php
/**
 * This class stands for BrokerCountryEnum EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:BrokerCountryEnum
 * @subpackage Enumerations
 */
class BrokerCountryEnum
{
    /**
     * Constant for value 'Unknown'
     * @return string 'Unknown'
     */
    const ENUM_VALUE_0 = 'Unknown';
    /**
     * Constant for value 'CZE'
     * @return string 'CZE'
     */
    const ENUM_VALUE_1 = 'CZE';
    /**
     * Constant for value 'SVK'
     * @return string 'SVK'
     */
    const ENUM_VALUE_2 = 'SVK';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::ENUM_VALUE_0
     * @uses self::ENUM_VALUE_1
     * @uses self::ENUM_VALUE_2
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::ENUM_VALUE_0,
            self::ENUM_VALUE_1,
            self::ENUM_VALUE_2,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
