<?php
use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDataElement ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfDataElement
 * @subpackage Arrays
 */
class ArrayOfDataElement extends AbstractStructArrayBase
{
    /**
     * The DataElement
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var DataElement[]
     */
    public $DataElement;
    /**
     * Constructor method for ArrayOfDataElement
     * @uses ArrayOfDataElement::setDataElement()
     * @param DataElement[] $dataElement
     */
    public function __construct(array $dataElement = array())
    {
        $this
            ->setDataElement($dataElement);
    }
    /**
     * Get DataElement value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return DataElement[]|null
     */
    public function getDataElement()
    {
        return isset($this->DataElement) ? $this->DataElement : null;
    }
    /**
     * Set DataElement value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param DataElement[] $dataElement
     * @return ArrayOfDataElement
     */
    public function setDataElement(array $dataElement = array())
    {
        if (is_null($dataElement) || (is_array($dataElement) && empty($dataElement))) {
            unset($this->DataElement);
        } else {
            $this->DataElement = $dataElement;
        }
        return $this;
    }
    /**
     * Add item to DataElement value
     * @throws \InvalidArgumentException
     * @param DataElement $item
     * @return ArrayOfDataElement
     */
    public function addToDataElement(DataElement $item)
    {
        $this->DataElement[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return DataElement|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return DataElement|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return DataElement|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return DataElement|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return DataElement|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DataElement
     */
    public function getAttributeName()
    {
        return 'DataElement';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return ArrayOfDataElement
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
