<?php
use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfContractInfo ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfContractInfo
 * @subpackage Arrays
 */
class ArrayOfContractInfo extends AbstractStructArrayBase
{
    /**
     * The ContractInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var ContractInfo[]
     */
    public $ContractInfo;
    /**
     * Constructor method for ArrayOfContractInfo
     * @uses ArrayOfContractInfo::setContractInfo()
     * @param ContractInfo[] $contractInfo
     */
    public function __construct(array $contractInfo = array())
    {
        $this
            ->setContractInfo($contractInfo);
    }
    /**
     * Get ContractInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return ContractInfo[]|null
     */
    public function getContractInfo()
    {
        return isset($this->ContractInfo) ? $this->ContractInfo : null;
    }
    /**
     * Set ContractInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param ContractInfo[] $contractInfo
     * @return ArrayOfContractInfo
     */
    public function setContractInfo(array $contractInfo = array())
    {
        if (is_null($contractInfo) || (is_array($contractInfo) && empty($contractInfo))) {
            unset($this->ContractInfo);
        } else {
            $this->ContractInfo = $contractInfo;
        }
        return $this;
    }
    /**
     * Add item to ContractInfo value
     * @throws \InvalidArgumentException
     * @param ContractInfo $item
     * @return ArrayOfContractInfo
     */
    public function addToContractInfo(ContractInfo $item)
    {
        $this->ContractInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return ContractInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return ContractInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return ContractInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return ContractInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return ContractInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ContractInfo
     */
    public function getAttributeName()
    {
        return 'ContractInfo';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return ArrayOfContractInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
