<?php
use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfContractEvent ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfContractEvent
 * @subpackage Arrays
 */
class ArrayOfContractEvent extends AbstractStructArrayBase
{
    /**
     * The ContractEvent
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var ContractEvent[]
     */
    public $ContractEvent;
    /**
     * Constructor method for ArrayOfContractEvent
     * @uses ArrayOfContractEvent::setContractEvent()
     * @param ContractEvent[] $contractEvent
     */
    public function __construct(array $contractEvent = array())
    {
        $this
            ->setContractEvent($contractEvent);
    }
    /**
     * Get ContractEvent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return ContractEvent[]|null
     */
    public function getContractEvent()
    {
        return isset($this->ContractEvent) ? $this->ContractEvent : null;
    }
    /**
     * Set ContractEvent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param ContractEvent[] $contractEvent
     * @return ArrayOfContractEvent
     */
    public function setContractEvent(array $contractEvent = array())
    {
        if (is_null($contractEvent) || (is_array($contractEvent) && empty($contractEvent))) {
            unset($this->ContractEvent);
        } else {
            $this->ContractEvent = $contractEvent;
        }
        return $this;
    }
    /**
     * Add item to ContractEvent value
     * @throws \InvalidArgumentException
     * @param ContractEvent $item
     * @return ArrayOfContractEvent
     */
    public function addToContractEvent(ContractEvent $item)
    {
        $this->ContractEvent[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return ContractEvent|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return ContractEvent|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return ContractEvent|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return ContractEvent|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return ContractEvent|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ContractEvent
     */
    public function getAttributeName()
    {
        return 'ContractEvent';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return ArrayOfContractEvent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
