<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Endpoint StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Endpoint
 * @subpackage Structs
 */
class Endpoint extends AbstractStructBase
{
    /**
     * The Service
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Service
     */
    public $Service;
    /**
     * The TestURL
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TestURL;
    /**
     * The URL
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $URL;
    /**
     * Constructor method for Endpoint
     * @uses Endpoint::setService()
     * @uses Endpoint::setTestURL()
     * @uses Endpoint::setURL()
     * @param \StructType\Service $service
     * @param string $testURL
     * @param string $uRL
     */
    public function __construct(\StructType\Service $service = null, $testURL = null, $uRL = null)
    {
        $this
            ->setService($service)
            ->setTestURL($testURL)
            ->setURL($uRL);
    }
    /**
     * Get Service value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Service|null
     */
    public function getService()
    {
        return isset($this->Service) ? $this->Service : null;
    }
    /**
     * Set Service value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Service $service
     * @return \StructType\Endpoint
     */
    public function setService(\StructType\Service $service = null)
    {
        if (is_null($service) || (is_array($service) && empty($service))) {
            unset($this->Service);
        } else {
            $this->Service = $service;
        }
        return $this;
    }
    /**
     * Get TestURL value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTestURL()
    {
        return isset($this->TestURL) ? $this->TestURL : null;
    }
    /**
     * Set TestURL value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $testURL
     * @return \StructType\Endpoint
     */
    public function setTestURL($testURL = null)
    {
        // validation for constraint: string
        if (!is_null($testURL) && !is_string($testURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($testURL, true), gettype($testURL)), __LINE__);
        }
        if (is_null($testURL) || (is_array($testURL) && empty($testURL))) {
            unset($this->TestURL);
        } else {
            $this->TestURL = $testURL;
        }
        return $this;
    }
    /**
     * Get URL value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getURL()
    {
        return isset($this->URL) ? $this->URL : null;
    }
    /**
     * Set URL value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uRL
     * @return \StructType\Endpoint
     */
    public function setURL($uRL = null)
    {
        // validation for constraint: string
        if (!is_null($uRL) && !is_string($uRL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uRL, true), gettype($uRL)), __LINE__);
        }
        if (is_null($uRL) || (is_array($uRL) && empty($uRL))) {
            unset($this->URL);
        } else {
            $this->URL = $uRL;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Endpoint
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
