<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetCompanies
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCompanies $parameters
     * @return \StructType\GetCompaniesResponse|bool
     */
    public function GetCompanies(\StructType\GetCompanies $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCompanies($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCompany
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCompany $parameters
     * @return \StructType\GetCompanyResponse|bool
     */
    public function GetCompany(\StructType\GetCompany $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCompany($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCompanyEndpoints
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCompanyEndpoints $parameters
     * @return \StructType\GetCompanyEndpointsResponse|bool
     */
    public function GetCompanyEndpoints(\StructType\GetCompanyEndpoints $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCompanyEndpoints($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCompanyEndpointsByServiceType
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCompanyEndpointsByServiceType $parameters
     * @return \StructType\GetCompanyEndpointsByServiceTypeResponse|bool
     */
    public function GetCompanyEndpointsByServiceType(\StructType\GetCompanyEndpointsByServiceType $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCompanyEndpointsByServiceType($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetCompanyEndpointsByServiceVersion
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCompanyEndpointsByServiceVersion $parameters
     * @return \StructType\GetCompanyEndpointsByServiceVersionResponse|bool
     */
    public function GetCompanyEndpointsByServiceVersion(\StructType\GetCompanyEndpointsByServiceVersion $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCompanyEndpointsByServiceVersion($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetServices
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetServices $parameters
     * @return \StructType\GetServicesResponse|bool
     */
    public function GetServices(\StructType\GetServices $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetServices($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetCompaniesResponse|\StructType\GetCompanyEndpointsByServiceTypeResponse|\StructType\GetCompanyEndpointsByServiceVersionResponse|\StructType\GetCompanyEndpointsResponse|\StructType\GetCompanyResponse|\StructType\GetServicesResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
