<?php
/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'GetCompanies' => '\\StructType\\GetCompanies',
            'GetCompaniesResponse' => '\\StructType\\GetCompaniesResponse',
            'GetCompany' => '\\StructType\\GetCompany',
            'GetCompanyResponse' => '\\StructType\\GetCompanyResponse',
            'GetCompanyEndpoints' => '\\StructType\\GetCompanyEndpoints',
            'GetCompanyEndpointsResponse' => '\\StructType\\GetCompanyEndpointsResponse',
            'GetCompanyEndpointsByServiceType' => '\\StructType\\GetCompanyEndpointsByServiceType',
            'GetCompanyEndpointsByServiceTypeResponse' => '\\StructType\\GetCompanyEndpointsByServiceTypeResponse',
            'GetCompanyEndpointsByServiceVersion' => '\\StructType\\GetCompanyEndpointsByServiceVersion',
            'GetCompanyEndpointsByServiceVersionResponse' => '\\StructType\\GetCompanyEndpointsByServiceVersionResponse',
            'GerServicesTypes' => '\\StructType\\GerServicesTypes',
            'GerServicesTypesResponse' => '\\StructType\\GerServicesTypesResponse',
            'GetServices' => '\\StructType\\GetServices',
            'GetServicesResponse' => '\\StructType\\GetServicesResponse',
            'ArrayOfCompany' => '\\ArrayType\\ArrayOfCompany',
            'Company' => '\\StructType\\Company',
            'ArrayOfEndpoint' => '\\ArrayType\\ArrayOfEndpoint',
            'Endpoint' => '\\StructType\\Endpoint',
            'Service' => '\\StructType\\Service',
            'ServiceType' => '\\StructType\\ServiceType',
            'ArrayOfServiceType' => '\\ArrayType\\ArrayOfServiceType',
            'ArrayOfService' => '\\ArrayType\\ArrayOfService',
        );
    }
}
