<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://services.promostandards.org/WebServiceRepository/WebServiceRepository.svc?singleWsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://services.promostandards.org/WebServiceRepository/WebServiceRepository.svc?singleWsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for GetCompanies operation/method
 */
if ($get->GetCompanies(new \StructType\GetCompanies()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCompany operation/method
 */
if ($get->GetCompany(new \StructType\GetCompany()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCompanyEndpoints operation/method
 */
if ($get->GetCompanyEndpoints(new \StructType\GetCompanyEndpoints()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCompanyEndpointsByServiceType operation/method
 */
if ($get->GetCompanyEndpointsByServiceType(new \StructType\GetCompanyEndpointsByServiceType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCompanyEndpointsByServiceVersion operation/method
 */
if ($get->GetCompanyEndpointsByServiceVersion(new \StructType\GetCompanyEndpointsByServiceVersion()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetServices operation/method
 */
if ($get->GetServices(new \StructType\GetServices()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Ger ServiceType
 */
$ger = new \ServiceType\Ger($options);
/**
 * Sample call for GerServicesTypes operation/method
 */
if ($ger->GerServicesTypes(new \StructType\GerServicesTypes()) !== false) {
    print_r($ger->getResult());
} else {
    print_r($ger->getLastError());
}
