<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Service StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Service
 * @subpackage Structs
 */
class Service extends AbstractStructBase
{
    /**
     * The ServiceType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ServiceType
     */
    public $ServiceType;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The Version
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Version;
    /**
     * The WSDL
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WSDL;
    /**
     * Constructor method for Service
     * @uses Service::setServiceType()
     * @uses Service::setStatus()
     * @uses Service::setVersion()
     * @uses Service::setWSDL()
     * @param \StructType\ServiceType $serviceType
     * @param string $status
     * @param string $version
     * @param string $wSDL
     */
    public function __construct(\StructType\ServiceType $serviceType = null, $status = null, $version = null, $wSDL = null)
    {
        $this
            ->setServiceType($serviceType)
            ->setStatus($status)
            ->setVersion($version)
            ->setWSDL($wSDL);
    }
    /**
     * Get ServiceType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ServiceType|null
     */
    public function getServiceType()
    {
        return isset($this->ServiceType) ? $this->ServiceType : null;
    }
    /**
     * Set ServiceType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ServiceType $serviceType
     * @return \StructType\Service
     */
    public function setServiceType(\StructType\ServiceType $serviceType = null)
    {
        if (is_null($serviceType) || (is_array($serviceType) && empty($serviceType))) {
            unset($this->ServiceType);
        } else {
            $this->ServiceType = $serviceType;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $status
     * @return \StructType\Service
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get Version value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVersion()
    {
        return isset($this->Version) ? $this->Version : null;
    }
    /**
     * Set Version value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $version
     * @return \StructType\Service
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        if (is_null($version) || (is_array($version) && empty($version))) {
            unset($this->Version);
        } else {
            $this->Version = $version;
        }
        return $this;
    }
    /**
     * Get WSDL value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWSDL()
    {
        return isset($this->WSDL) ? $this->WSDL : null;
    }
    /**
     * Set WSDL value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $wSDL
     * @return \StructType\Service
     */
    public function setWSDL($wSDL = null)
    {
        // validation for constraint: string
        if (!is_null($wSDL) && !is_string($wSDL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wSDL, true), gettype($wSDL)), __LINE__);
        }
        if (is_null($wSDL) || (is_array($wSDL) && empty($wSDL))) {
            unset($this->WSDL);
        } else {
            $this->WSDL = $wSDL;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Service
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
