<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Ger ServiceType
 * @subpackage Services
 */
class Ger extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GerServicesTypes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GerServicesTypes $parameters
     * @return \StructType\GerServicesTypesResponse|bool
     */
    public function GerServicesTypes(\StructType\GerServicesTypes $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GerServicesTypes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GerServicesTypesResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
