<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCompany ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfCompany
 * @subpackage Arrays
 */
class ArrayOfCompany extends AbstractStructArrayBase
{
    /**
     * The Company
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Company[]
     */
    public $Company;
    /**
     * Constructor method for ArrayOfCompany
     * @uses ArrayOfCompany::setCompany()
     * @param \StructType\Company[] $company
     */
    public function __construct(array $company = array())
    {
        $this
            ->setCompany($company);
    }
    /**
     * Get Company value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Company[]|null
     */
    public function getCompany()
    {
        return isset($this->Company) ? $this->Company : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCompany method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCompany method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCompanyForArrayConstraintsFromSetCompany(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfCompanyCompanyItem) {
            // validation for constraint: itemType
            if (!$arrayOfCompanyCompanyItem instanceof \StructType\Company) {
                $invalidValues[] = is_object($arrayOfCompanyCompanyItem) ? get_class($arrayOfCompanyCompanyItem) : sprintf('%s(%s)', gettype($arrayOfCompanyCompanyItem), var_export($arrayOfCompanyCompanyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Company property can only contain items of type \StructType\Company, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Company value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Company[] $company
     * @return \ArrayType\ArrayOfCompany
     */
    public function setCompany(array $company = array())
    {
        // validation for constraint: array
        if ('' !== ($companyArrayErrorMessage = self::validateCompanyForArrayConstraintsFromSetCompany($company))) {
            throw new \InvalidArgumentException($companyArrayErrorMessage, __LINE__);
        }
        if (is_null($company) || (is_array($company) && empty($company))) {
            unset($this->Company);
        } else {
            $this->Company = $company;
        }
        return $this;
    }
    /**
     * Add item to Company value
     * @throws \InvalidArgumentException
     * @param \StructType\Company $item
     * @return \ArrayType\ArrayOfCompany
     */
    public function addToCompany(\StructType\Company $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Company) {
            throw new \InvalidArgumentException(sprintf('The Company property can only contain items of type \StructType\Company, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Company[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Company|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Company|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Company|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Company|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Company|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Company
     */
    public function getAttributeName()
    {
        return 'Company';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfCompany
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
