<?php

namespace TurnedAwayBOSS\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SubjectPropertyAddress StructType
 * @subpackage Structs
 */
class SubjectPropertyAddress extends Address
{
    /**
     * The OccupancyTypeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $OccupancyTypeId;
    /**
     * The MlsListingFlag
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $MlsListingFlag;
    /**
     * Constructor method for SubjectPropertyAddress
     * @uses SubjectPropertyAddress::setOccupancyTypeId()
     * @uses SubjectPropertyAddress::setMlsListingFlag()
     * @param string $occupancyTypeId
     * @param bool $mlsListingFlag
     */
    public function __construct($occupancyTypeId = null, $mlsListingFlag = null)
    {
        $this
            ->setOccupancyTypeId($occupancyTypeId)
            ->setMlsListingFlag($mlsListingFlag);
    }
    /**
     * Get OccupancyTypeId value
     * @return string
     */
    public function getOccupancyTypeId()
    {
        return $this->OccupancyTypeId;
    }
    /**
     * Set OccupancyTypeId value
     * @uses \TurnedAwayBOSS\EnumType\OccupancyType::valueIsValid()
     * @uses \TurnedAwayBOSS\EnumType\OccupancyType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $occupancyTypeId
     * @return \TurnedAwayBOSS\StructType\SubjectPropertyAddress
     */
    public function setOccupancyTypeId($occupancyTypeId = null)
    {
        // validation for constraint: enumeration
        if (!\TurnedAwayBOSS\EnumType\OccupancyType::valueIsValid($occupancyTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \TurnedAwayBOSS\EnumType\OccupancyType', is_array($occupancyTypeId) ? implode(', ', $occupancyTypeId) : var_export($occupancyTypeId, true), implode(', ', \TurnedAwayBOSS\EnumType\OccupancyType::getValidValues())), __LINE__);
        }
        $this->OccupancyTypeId = $occupancyTypeId;
        return $this;
    }
    /**
     * Get MlsListingFlag value
     * @return bool
     */
    public function getMlsListingFlag()
    {
        return $this->MlsListingFlag;
    }
    /**
     * Set MlsListingFlag value
     * @param bool $mlsListingFlag
     * @return \TurnedAwayBOSS\StructType\SubjectPropertyAddress
     */
    public function setMlsListingFlag($mlsListingFlag = null)
    {
        // validation for constraint: boolean
        if (!is_null($mlsListingFlag) && !is_bool($mlsListingFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mlsListingFlag, true), gettype($mlsListingFlag)), __LINE__);
        }
        $this->MlsListingFlag = $mlsListingFlag;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \TurnedAwayBOSS\StructType\SubjectPropertyAddress
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
