<?php

namespace TurnedAwayBOSS\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Response StructType
 * @subpackage Structs
 */
class Response extends AbstractStructBase
{
    /**
     * The MaxAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $MaxAmount;
    /**
     * The InsuranceAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $InsuranceAmount;
    /**
     * The TotalDebt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalDebt;
    /**
     * The ClientType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ClientType;
    /**
     * The ApplicantResult
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ApplicantResult;
    /**
     * The CreditScore
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CreditScore;
    /**
     * The Conditions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Conditions;
    /**
     * The ConditionText
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ConditionText;
    /**
     * Constructor method for Response
     * @uses Response::setMaxAmount()
     * @uses Response::setInsuranceAmount()
     * @uses Response::setTotalDebt()
     * @uses Response::setClientType()
     * @uses Response::setApplicantResult()
     * @uses Response::setCreditScore()
     * @uses Response::setConditions()
     * @uses Response::setConditionText()
     * @param float $maxAmount
     * @param float $insuranceAmount
     * @param float $totalDebt
     * @param int $clientType
     * @param int $applicantResult
     * @param string $creditScore
     * @param string $conditions
     * @param string $conditionText
     */
    public function __construct($maxAmount = null, $insuranceAmount = null, $totalDebt = null, $clientType = null, $applicantResult = null, $creditScore = null, $conditions = null, $conditionText = null)
    {
        $this
            ->setMaxAmount($maxAmount)
            ->setInsuranceAmount($insuranceAmount)
            ->setTotalDebt($totalDebt)
            ->setClientType($clientType)
            ->setApplicantResult($applicantResult)
            ->setCreditScore($creditScore)
            ->setConditions($conditions)
            ->setConditionText($conditionText);
    }
    /**
     * Get MaxAmount value
     * @return float
     */
    public function getMaxAmount()
    {
        return $this->MaxAmount;
    }
    /**
     * Set MaxAmount value
     * @param float $maxAmount
     * @return \TurnedAwayBOSS\StructType\Response
     */
    public function setMaxAmount($maxAmount = null)
    {
        // validation for constraint: float
        if (!is_null($maxAmount) && !(is_float($maxAmount) || is_numeric($maxAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maxAmount, true), gettype($maxAmount)), __LINE__);
        }
        $this->MaxAmount = $maxAmount;
        return $this;
    }
    /**
     * Get InsuranceAmount value
     * @return float
     */
    public function getInsuranceAmount()
    {
        return $this->InsuranceAmount;
    }
    /**
     * Set InsuranceAmount value
     * @param float $insuranceAmount
     * @return \TurnedAwayBOSS\StructType\Response
     */
    public function setInsuranceAmount($insuranceAmount = null)
    {
        // validation for constraint: float
        if (!is_null($insuranceAmount) && !(is_float($insuranceAmount) || is_numeric($insuranceAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($insuranceAmount, true), gettype($insuranceAmount)), __LINE__);
        }
        $this->InsuranceAmount = $insuranceAmount;
        return $this;
    }
    /**
     * Get TotalDebt value
     * @return float
     */
    public function getTotalDebt()
    {
        return $this->TotalDebt;
    }
    /**
     * Set TotalDebt value
     * @param float $totalDebt
     * @return \TurnedAwayBOSS\StructType\Response
     */
    public function setTotalDebt($totalDebt = null)
    {
        // validation for constraint: float
        if (!is_null($totalDebt) && !(is_float($totalDebt) || is_numeric($totalDebt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalDebt, true), gettype($totalDebt)), __LINE__);
        }
        $this->TotalDebt = $totalDebt;
        return $this;
    }
    /**
     * Get ClientType value
     * @return int
     */
    public function getClientType()
    {
        return $this->ClientType;
    }
    /**
     * Set ClientType value
     * @param int $clientType
     * @return \TurnedAwayBOSS\StructType\Response
     */
    public function setClientType($clientType = null)
    {
        // validation for constraint: int
        if (!is_null($clientType) && !(is_int($clientType) || ctype_digit($clientType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($clientType, true), gettype($clientType)), __LINE__);
        }
        $this->ClientType = $clientType;
        return $this;
    }
    /**
     * Get ApplicantResult value
     * @return int
     */
    public function getApplicantResult()
    {
        return $this->ApplicantResult;
    }
    /**
     * Set ApplicantResult value
     * @param int $applicantResult
     * @return \TurnedAwayBOSS\StructType\Response
     */
    public function setApplicantResult($applicantResult = null)
    {
        // validation for constraint: int
        if (!is_null($applicantResult) && !(is_int($applicantResult) || ctype_digit($applicantResult))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($applicantResult, true), gettype($applicantResult)), __LINE__);
        }
        $this->ApplicantResult = $applicantResult;
        return $this;
    }
    /**
     * Get CreditScore value
     * @return string|null
     */
    public function getCreditScore()
    {
        return $this->CreditScore;
    }
    /**
     * Set CreditScore value
     * @param string $creditScore
     * @return \TurnedAwayBOSS\StructType\Response
     */
    public function setCreditScore($creditScore = null)
    {
        // validation for constraint: string
        if (!is_null($creditScore) && !is_string($creditScore)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creditScore, true), gettype($creditScore)), __LINE__);
        }
        $this->CreditScore = $creditScore;
        return $this;
    }
    /**
     * Get Conditions value
     * @return string|null
     */
    public function getConditions()
    {
        return $this->Conditions;
    }
    /**
     * Set Conditions value
     * @param string $conditions
     * @return \TurnedAwayBOSS\StructType\Response
     */
    public function setConditions($conditions = null)
    {
        // validation for constraint: string
        if (!is_null($conditions) && !is_string($conditions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($conditions, true), gettype($conditions)), __LINE__);
        }
        $this->Conditions = $conditions;
        return $this;
    }
    /**
     * Get ConditionText value
     * @return string|null
     */
    public function getConditionText()
    {
        return $this->ConditionText;
    }
    /**
     * Set ConditionText value
     * @param string $conditionText
     * @return \TurnedAwayBOSS\StructType\Response
     */
    public function setConditionText($conditionText = null)
    {
        // validation for constraint: string
        if (!is_null($conditionText) && !is_string($conditionText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($conditionText, true), gettype($conditionText)), __LINE__);
        }
        $this->ConditionText = $conditionText;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \TurnedAwayBOSS\StructType\Response
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
