<?php

namespace TurnedAwayBOSS\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Rate StructType
 * @subpackage Structs
 */
class Rate extends AbstractStructBase
{
    /**
     * The RequestedRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $RequestedRate;
    /**
     * The Discount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Discount;
    /**
     * The Premium
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Premium;
    /**
     * The BuyDownRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $BuyDownRate;
    /**
     * The NetRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $NetRate;
    /**
     * Constructor method for Rate
     * @uses Rate::setRequestedRate()
     * @uses Rate::setDiscount()
     * @uses Rate::setPremium()
     * @uses Rate::setBuyDownRate()
     * @uses Rate::setNetRate()
     * @param float $requestedRate
     * @param float $discount
     * @param float $premium
     * @param float $buyDownRate
     * @param float $netRate
     */
    public function __construct($requestedRate = null, $discount = null, $premium = null, $buyDownRate = null, $netRate = null)
    {
        $this
            ->setRequestedRate($requestedRate)
            ->setDiscount($discount)
            ->setPremium($premium)
            ->setBuyDownRate($buyDownRate)
            ->setNetRate($netRate);
    }
    /**
     * Get RequestedRate value
     * @return float
     */
    public function getRequestedRate()
    {
        return $this->RequestedRate;
    }
    /**
     * Set RequestedRate value
     * @param float $requestedRate
     * @return \TurnedAwayBOSS\StructType\Rate
     */
    public function setRequestedRate($requestedRate = null)
    {
        // validation for constraint: float
        if (!is_null($requestedRate) && !(is_float($requestedRate) || is_numeric($requestedRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($requestedRate, true), gettype($requestedRate)), __LINE__);
        }
        $this->RequestedRate = $requestedRate;
        return $this;
    }
    /**
     * Get Discount value
     * @return float
     */
    public function getDiscount()
    {
        return $this->Discount;
    }
    /**
     * Set Discount value
     * @param float $discount
     * @return \TurnedAwayBOSS\StructType\Rate
     */
    public function setDiscount($discount = null)
    {
        // validation for constraint: float
        if (!is_null($discount) && !(is_float($discount) || is_numeric($discount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($discount, true), gettype($discount)), __LINE__);
        }
        $this->Discount = $discount;
        return $this;
    }
    /**
     * Get Premium value
     * @return float
     */
    public function getPremium()
    {
        return $this->Premium;
    }
    /**
     * Set Premium value
     * @param float $premium
     * @return \TurnedAwayBOSS\StructType\Rate
     */
    public function setPremium($premium = null)
    {
        // validation for constraint: float
        if (!is_null($premium) && !(is_float($premium) || is_numeric($premium))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($premium, true), gettype($premium)), __LINE__);
        }
        $this->Premium = $premium;
        return $this;
    }
    /**
     * Get BuyDownRate value
     * @return float
     */
    public function getBuyDownRate()
    {
        return $this->BuyDownRate;
    }
    /**
     * Set BuyDownRate value
     * @param float $buyDownRate
     * @return \TurnedAwayBOSS\StructType\Rate
     */
    public function setBuyDownRate($buyDownRate = null)
    {
        // validation for constraint: float
        if (!is_null($buyDownRate) && !(is_float($buyDownRate) || is_numeric($buyDownRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($buyDownRate, true), gettype($buyDownRate)), __LINE__);
        }
        $this->BuyDownRate = $buyDownRate;
        return $this;
    }
    /**
     * Get NetRate value
     * @return float
     */
    public function getNetRate()
    {
        return $this->NetRate;
    }
    /**
     * Set NetRate value
     * @param float $netRate
     * @return \TurnedAwayBOSS\StructType\Rate
     */
    public function setNetRate($netRate = null)
    {
        // validation for constraint: float
        if (!is_null($netRate) && !(is_float($netRate) || is_numeric($netRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($netRate, true), gettype($netRate)), __LINE__);
        }
        $this->NetRate = $netRate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \TurnedAwayBOSS\StructType\Rate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
