<?php

namespace TurnedAwayBOSS\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PushDealResponse StructType
 * @subpackage Structs
 */
class PushDealResponse extends AbstractStructBase
{
    /**
     * The LeadApiId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $LeadApiId;
    /**
     * The NetworkId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $NetworkId;
    /**
     * The PushDealResult
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurnedAwayBOSS\StructType\PushDealResponse
     */
    public $PushDealResult;
    /**
     * The Qualification
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurnedAwayBOSS\StructType\Response
     */
    public $Qualification;
    /**
     * The Brand
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Brand;
    /**
     * Constructor method for PushDealResponse
     * @uses PushDealResponse::setLeadApiId()
     * @uses PushDealResponse::setNetworkId()
     * @uses PushDealResponse::setPushDealResult()
     * @uses PushDealResponse::setQualification()
     * @uses PushDealResponse::setBrand()
     * @param string $leadApiId
     * @param int $networkId
     * @param \TurnedAwayBOSS\StructType\PushDealResponse $pushDealResult
     * @param \TurnedAwayBOSS\StructType\Response $qualification
     * @param string $brand
     */
    public function __construct($leadApiId = null, $networkId = null, \TurnedAwayBOSS\StructType\PushDealResponse $pushDealResult = null, \TurnedAwayBOSS\StructType\Response $qualification = null, $brand = null)
    {
        $this
            ->setLeadApiId($leadApiId)
            ->setNetworkId($networkId)
            ->setPushDealResult($pushDealResult)
            ->setQualification($qualification)
            ->setBrand($brand);
    }
    /**
     * Get LeadApiId value
     * @return string
     */
    public function getLeadApiId()
    {
        return $this->LeadApiId;
    }
    /**
     * Set LeadApiId value
     * @param string $leadApiId
     * @return \TurnedAwayBOSS\StructType\PushDealResponse
     */
    public function setLeadApiId($leadApiId = null)
    {
        // validation for constraint: string
        if (!is_null($leadApiId) && !is_string($leadApiId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($leadApiId, true), gettype($leadApiId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($leadApiId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $leadApiId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($leadApiId, true)), __LINE__);
        }
        $this->LeadApiId = $leadApiId;
        return $this;
    }
    /**
     * Get NetworkId value
     * @return int
     */
    public function getNetworkId()
    {
        return $this->NetworkId;
    }
    /**
     * Set NetworkId value
     * @param int $networkId
     * @return \TurnedAwayBOSS\StructType\PushDealResponse
     */
    public function setNetworkId($networkId = null)
    {
        // validation for constraint: int
        if (!is_null($networkId) && !(is_int($networkId) || ctype_digit($networkId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($networkId, true), gettype($networkId)), __LINE__);
        }
        $this->NetworkId = $networkId;
        return $this;
    }
    /**
     * Get PushDealResult value
     * @return \TurnedAwayBOSS\StructType\PushDealResponse|null
     */
    public function getPushDealResult()
    {
        return $this->PushDealResult;
    }
    /**
     * Set PushDealResult value
     * @param \TurnedAwayBOSS\StructType\PushDealResponse $pushDealResult
     * @return \TurnedAwayBOSS\StructType\PushDealResponse
     */
    public function setPushDealResult(\TurnedAwayBOSS\StructType\PushDealResponse $pushDealResult = null)
    {
        $this->PushDealResult = $pushDealResult;
        return $this;
    }
    /**
     * Get Qualification value
     * @return \TurnedAwayBOSS\StructType\Response|null
     */
    public function getQualification()
    {
        return $this->Qualification;
    }
    /**
     * Set Qualification value
     * @param \TurnedAwayBOSS\StructType\Response $qualification
     * @return \TurnedAwayBOSS\StructType\PushDealResponse
     */
    public function setQualification(\TurnedAwayBOSS\StructType\Response $qualification = null)
    {
        $this->Qualification = $qualification;
        return $this;
    }
    /**
     * Get Brand value
     * @return string|null
     */
    public function getBrand()
    {
        return $this->Brand;
    }
    /**
     * Set Brand value
     * @param string $brand
     * @return \TurnedAwayBOSS\StructType\PushDealResponse
     */
    public function setBrand($brand = null)
    {
        // validation for constraint: string
        if (!is_null($brand) && !is_string($brand)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($brand, true), gettype($brand)), __LINE__);
        }
        $this->Brand = $brand;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \TurnedAwayBOSS\StructType\PushDealResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
