<?php

namespace TurnedAwayBOSS\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PushDeal StructType
 * @subpackage Structs
 */
class PushDeal extends AbstractStructBase
{
    /**
     * The token
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $token;
    /**
     * The deal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurnedAwayBOSS\StructType\Deal
     */
    public $deal;
    /**
     * Constructor method for PushDeal
     * @uses PushDeal::setToken()
     * @uses PushDeal::setDeal()
     * @param string $token
     * @param \TurnedAwayBOSS\StructType\Deal $deal
     */
    public function __construct($token = null, \TurnedAwayBOSS\StructType\Deal $deal = null)
    {
        $this
            ->setToken($token)
            ->setDeal($deal);
    }
    /**
     * Get token value
     * @return string
     */
    public function getToken()
    {
        return $this->token;
    }
    /**
     * Set token value
     * @param string $token
     * @return \TurnedAwayBOSS\StructType\PushDeal
     */
    public function setToken($token = null)
    {
        // validation for constraint: string
        if (!is_null($token) && !is_string($token)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($token, true), gettype($token)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($token) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $token)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($token, true)), __LINE__);
        }
        $this->token = $token;
        return $this;
    }
    /**
     * Get deal value
     * @return \TurnedAwayBOSS\StructType\Deal|null
     */
    public function getDeal()
    {
        return $this->deal;
    }
    /**
     * Set deal value
     * @param \TurnedAwayBOSS\StructType\Deal $deal
     * @return \TurnedAwayBOSS\StructType\PushDeal
     */
    public function setDeal(\TurnedAwayBOSS\StructType\Deal $deal = null)
    {
        $this->deal = $deal;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \TurnedAwayBOSS\StructType\PushDeal
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
