<?php

namespace TurnedAwayBOSS\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PropertyExpense StructType
 * @subpackage Structs
 */
class PropertyExpense extends AbstractStructBase
{
    /**
     * The PropertyExpenseAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $PropertyExpenseAmount;
    /**
     * The PropertyExpensePeriodId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $PropertyExpensePeriodId;
    /**
     * The PropertyExpenseTypeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $PropertyExpenseTypeId;
    /**
     * Constructor method for PropertyExpense
     * @uses PropertyExpense::setPropertyExpenseAmount()
     * @uses PropertyExpense::setPropertyExpensePeriodId()
     * @uses PropertyExpense::setPropertyExpenseTypeId()
     * @param float $propertyExpenseAmount
     * @param string $propertyExpensePeriodId
     * @param string $propertyExpenseTypeId
     */
    public function __construct($propertyExpenseAmount = null, $propertyExpensePeriodId = null, $propertyExpenseTypeId = null)
    {
        $this
            ->setPropertyExpenseAmount($propertyExpenseAmount)
            ->setPropertyExpensePeriodId($propertyExpensePeriodId)
            ->setPropertyExpenseTypeId($propertyExpenseTypeId);
    }
    /**
     * Get PropertyExpenseAmount value
     * @return float
     */
    public function getPropertyExpenseAmount()
    {
        return $this->PropertyExpenseAmount;
    }
    /**
     * Set PropertyExpenseAmount value
     * @param float $propertyExpenseAmount
     * @return \TurnedAwayBOSS\StructType\PropertyExpense
     */
    public function setPropertyExpenseAmount($propertyExpenseAmount = null)
    {
        // validation for constraint: float
        if (!is_null($propertyExpenseAmount) && !(is_float($propertyExpenseAmount) || is_numeric($propertyExpenseAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($propertyExpenseAmount, true), gettype($propertyExpenseAmount)), __LINE__);
        }
        $this->PropertyExpenseAmount = $propertyExpenseAmount;
        return $this;
    }
    /**
     * Get PropertyExpensePeriodId value
     * @return string
     */
    public function getPropertyExpensePeriodId()
    {
        return $this->PropertyExpensePeriodId;
    }
    /**
     * Set PropertyExpensePeriodId value
     * @uses \TurnedAwayBOSS\EnumType\Period::valueIsValid()
     * @uses \TurnedAwayBOSS\EnumType\Period::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $propertyExpensePeriodId
     * @return \TurnedAwayBOSS\StructType\PropertyExpense
     */
    public function setPropertyExpensePeriodId($propertyExpensePeriodId = null)
    {
        // validation for constraint: enumeration
        if (!\TurnedAwayBOSS\EnumType\Period::valueIsValid($propertyExpensePeriodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \TurnedAwayBOSS\EnumType\Period', is_array($propertyExpensePeriodId) ? implode(', ', $propertyExpensePeriodId) : var_export($propertyExpensePeriodId, true), implode(', ', \TurnedAwayBOSS\EnumType\Period::getValidValues())), __LINE__);
        }
        $this->PropertyExpensePeriodId = $propertyExpensePeriodId;
        return $this;
    }
    /**
     * Get PropertyExpenseTypeId value
     * @return string
     */
    public function getPropertyExpenseTypeId()
    {
        return $this->PropertyExpenseTypeId;
    }
    /**
     * Set PropertyExpenseTypeId value
     * @uses \TurnedAwayBOSS\EnumType\PropertyExpenseType::valueIsValid()
     * @uses \TurnedAwayBOSS\EnumType\PropertyExpenseType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $propertyExpenseTypeId
     * @return \TurnedAwayBOSS\StructType\PropertyExpense
     */
    public function setPropertyExpenseTypeId($propertyExpenseTypeId = null)
    {
        // validation for constraint: enumeration
        if (!\TurnedAwayBOSS\EnumType\PropertyExpenseType::valueIsValid($propertyExpenseTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \TurnedAwayBOSS\EnumType\PropertyExpenseType', is_array($propertyExpenseTypeId) ? implode(', ', $propertyExpenseTypeId) : var_export($propertyExpenseTypeId, true), implode(', ', \TurnedAwayBOSS\EnumType\PropertyExpenseType::getValidValues())), __LINE__);
        }
        $this->PropertyExpenseTypeId = $propertyExpenseTypeId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \TurnedAwayBOSS\StructType\PropertyExpense
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
