<?php

namespace TurnedAwayBOSS\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Phone StructType
 * @subpackage Structs
 */
class Phone extends AbstractStructBase
{
    /**
     * The PhoneTypeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $PhoneTypeId;
    /**
     * The PhoneNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $PhoneNumber;
    /**
     * The PhoneExtension
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $PhoneExtension;
    /**
     * Constructor method for Phone
     * @uses Phone::setPhoneTypeId()
     * @uses Phone::setPhoneNumber()
     * @uses Phone::setPhoneExtension()
     * @param string $phoneTypeId
     * @param string $phoneNumber
     * @param string $phoneExtension
     */
    public function __construct($phoneTypeId = null, $phoneNumber = null, $phoneExtension = null)
    {
        $this
            ->setPhoneTypeId($phoneTypeId)
            ->setPhoneNumber($phoneNumber)
            ->setPhoneExtension($phoneExtension);
    }
    /**
     * Get PhoneTypeId value
     * @return string
     */
    public function getPhoneTypeId()
    {
        return $this->PhoneTypeId;
    }
    /**
     * Set PhoneTypeId value
     * @uses \TurnedAwayBOSS\EnumType\PhoneType::valueIsValid()
     * @uses \TurnedAwayBOSS\EnumType\PhoneType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $phoneTypeId
     * @return \TurnedAwayBOSS\StructType\Phone
     */
    public function setPhoneTypeId($phoneTypeId = null)
    {
        // validation for constraint: enumeration
        if (!\TurnedAwayBOSS\EnumType\PhoneType::valueIsValid($phoneTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \TurnedAwayBOSS\EnumType\PhoneType', is_array($phoneTypeId) ? implode(', ', $phoneTypeId) : var_export($phoneTypeId, true), implode(', ', \TurnedAwayBOSS\EnumType\PhoneType::getValidValues())), __LINE__);
        }
        $this->PhoneTypeId = $phoneTypeId;
        return $this;
    }
    /**
     * Get PhoneNumber value
     * @return string
     */
    public function getPhoneNumber()
    {
        return $this->PhoneNumber;
    }
    /**
     * Set PhoneNumber value
     * @param string $phoneNumber
     * @return \TurnedAwayBOSS\StructType\Phone
     */
    public function setPhoneNumber($phoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($phoneNumber) && !is_string($phoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phoneNumber, true), gettype($phoneNumber)), __LINE__);
        }
        $this->PhoneNumber = $phoneNumber;
        return $this;
    }
    /**
     * Get PhoneExtension value
     * @return string
     */
    public function getPhoneExtension()
    {
        return $this->PhoneExtension;
    }
    /**
     * Set PhoneExtension value
     * @param string $phoneExtension
     * @return \TurnedAwayBOSS\StructType\Phone
     */
    public function setPhoneExtension($phoneExtension = null)
    {
        // validation for constraint: string
        if (!is_null($phoneExtension) && !is_string($phoneExtension)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phoneExtension, true), gettype($phoneExtension)), __LINE__);
        }
        $this->PhoneExtension = $phoneExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \TurnedAwayBOSS\StructType\Phone
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
