<?php

namespace TurnedAwayBOSS\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Name StructType
 * @subpackage Structs
 */
class Name extends AbstractStructBase
{
    /**
     * The SalutationId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $SalutationId;
    /**
     * The MiddleInitial
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $MiddleInitial;
    /**
     * The SuffixId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $SuffixId;
    /**
     * The FirstName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FirstName;
    /**
     * The LastName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastName;
    /**
     * Constructor method for Name
     * @uses Name::setSalutationId()
     * @uses Name::setMiddleInitial()
     * @uses Name::setSuffixId()
     * @uses Name::setFirstName()
     * @uses Name::setLastName()
     * @param string $salutationId
     * @param string $middleInitial
     * @param string $suffixId
     * @param string $firstName
     * @param string $lastName
     */
    public function __construct($salutationId = null, $middleInitial = null, $suffixId = null, $firstName = null, $lastName = null)
    {
        $this
            ->setSalutationId($salutationId)
            ->setMiddleInitial($middleInitial)
            ->setSuffixId($suffixId)
            ->setFirstName($firstName)
            ->setLastName($lastName);
    }
    /**
     * Get SalutationId value
     * @return string
     */
    public function getSalutationId()
    {
        return $this->SalutationId;
    }
    /**
     * Set SalutationId value
     * @uses \TurnedAwayBOSS\EnumType\Salutation::valueIsValid()
     * @uses \TurnedAwayBOSS\EnumType\Salutation::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $salutationId
     * @return \TurnedAwayBOSS\StructType\Name
     */
    public function setSalutationId($salutationId = null)
    {
        // validation for constraint: enumeration
        if (!\TurnedAwayBOSS\EnumType\Salutation::valueIsValid($salutationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \TurnedAwayBOSS\EnumType\Salutation', is_array($salutationId) ? implode(', ', $salutationId) : var_export($salutationId, true), implode(', ', \TurnedAwayBOSS\EnumType\Salutation::getValidValues())), __LINE__);
        }
        $this->SalutationId = $salutationId;
        return $this;
    }
    /**
     * Get MiddleInitial value
     * @return string
     */
    public function getMiddleInitial()
    {
        return $this->MiddleInitial;
    }
    /**
     * Set MiddleInitial value
     * @param string $middleInitial
     * @return \TurnedAwayBOSS\StructType\Name
     */
    public function setMiddleInitial($middleInitial = null)
    {
        // validation for constraint: string
        if (!is_null($middleInitial) && !is_string($middleInitial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($middleInitial, true), gettype($middleInitial)), __LINE__);
        }
        $this->MiddleInitial = $middleInitial;
        return $this;
    }
    /**
     * Get SuffixId value
     * @return string
     */
    public function getSuffixId()
    {
        return $this->SuffixId;
    }
    /**
     * Set SuffixId value
     * @uses \TurnedAwayBOSS\EnumType\Suffix::valueIsValid()
     * @uses \TurnedAwayBOSS\EnumType\Suffix::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $suffixId
     * @return \TurnedAwayBOSS\StructType\Name
     */
    public function setSuffixId($suffixId = null)
    {
        // validation for constraint: enumeration
        if (!\TurnedAwayBOSS\EnumType\Suffix::valueIsValid($suffixId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \TurnedAwayBOSS\EnumType\Suffix', is_array($suffixId) ? implode(', ', $suffixId) : var_export($suffixId, true), implode(', ', \TurnedAwayBOSS\EnumType\Suffix::getValidValues())), __LINE__);
        }
        $this->SuffixId = $suffixId;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \TurnedAwayBOSS\StructType\Name
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \TurnedAwayBOSS\StructType\Name
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \TurnedAwayBOSS\StructType\Name
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
