<?php

namespace TurnedAwayBOSS\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Identification StructType
 * @subpackage Structs
 */
class Identification extends AbstractStructBase
{
    /**
     * The IdentificationNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $IdentificationNumber;
    /**
     * The IdentificationCountry
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $IdentificationCountry;
    /**
     * The IdentificationTypeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $IdentificationTypeId;
    /**
     * Constructor method for Identification
     * @uses Identification::setIdentificationNumber()
     * @uses Identification::setIdentificationCountry()
     * @uses Identification::setIdentificationTypeId()
     * @param string $identificationNumber
     * @param string $identificationCountry
     * @param string $identificationTypeId
     */
    public function __construct($identificationNumber = null, $identificationCountry = null, $identificationTypeId = null)
    {
        $this
            ->setIdentificationNumber($identificationNumber)
            ->setIdentificationCountry($identificationCountry)
            ->setIdentificationTypeId($identificationTypeId);
    }
    /**
     * Get IdentificationNumber value
     * @return string
     */
    public function getIdentificationNumber()
    {
        return $this->IdentificationNumber;
    }
    /**
     * Set IdentificationNumber value
     * @param string $identificationNumber
     * @return \TurnedAwayBOSS\StructType\Identification
     */
    public function setIdentificationNumber($identificationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($identificationNumber) && !is_string($identificationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identificationNumber, true), gettype($identificationNumber)), __LINE__);
        }
        $this->IdentificationNumber = $identificationNumber;
        return $this;
    }
    /**
     * Get IdentificationCountry value
     * @return string
     */
    public function getIdentificationCountry()
    {
        return $this->IdentificationCountry;
    }
    /**
     * Set IdentificationCountry value
     * @param string $identificationCountry
     * @return \TurnedAwayBOSS\StructType\Identification
     */
    public function setIdentificationCountry($identificationCountry = null)
    {
        // validation for constraint: string
        if (!is_null($identificationCountry) && !is_string($identificationCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identificationCountry, true), gettype($identificationCountry)), __LINE__);
        }
        $this->IdentificationCountry = $identificationCountry;
        return $this;
    }
    /**
     * Get IdentificationTypeId value
     * @return string
     */
    public function getIdentificationTypeId()
    {
        return $this->IdentificationTypeId;
    }
    /**
     * Set IdentificationTypeId value
     * @uses \TurnedAwayBOSS\EnumType\IdentificationType::valueIsValid()
     * @uses \TurnedAwayBOSS\EnumType\IdentificationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $identificationTypeId
     * @return \TurnedAwayBOSS\StructType\Identification
     */
    public function setIdentificationTypeId($identificationTypeId = null)
    {
        // validation for constraint: enumeration
        if (!\TurnedAwayBOSS\EnumType\IdentificationType::valueIsValid($identificationTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \TurnedAwayBOSS\EnumType\IdentificationType', is_array($identificationTypeId) ? implode(', ', $identificationTypeId) : var_export($identificationTypeId, true), implode(', ', \TurnedAwayBOSS\EnumType\IdentificationType::getValidValues())), __LINE__);
        }
        $this->IdentificationTypeId = $identificationTypeId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \TurnedAwayBOSS\StructType\Identification
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
