<?php

namespace TurnedAwayBOSS\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExistingMortgage StructType
 * @subpackage Structs
 */
class ExistingMortgage extends AbstractStructBase
{
    /**
     * The MortgageTypeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $MortgageTypeId;
    /**
     * The PAndIPaymentAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $PAndIPaymentAmount;
    /**
     * The PaymentFrequencyId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $PaymentFrequencyId;
    /**
     * The MaturityDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $MaturityDate;
    /**
     * The InterestTypeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $InterestTypeId;
    /**
     * The PaymentTermId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $PaymentTermId;
    /**
     * The BalanceRemaining
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $BalanceRemaining;
    /**
     * The ExistingMortgageHolder
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ExistingMortgageHolder;
    /**
     * The PayoffTypeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $PayoffTypeId;
    /**
     * The InterestRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $InterestRate;
    /**
     * The LoanAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $LoanAmount;
    /**
     * The InterestOnly
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $InterestOnly;
    /**
     * Constructor method for ExistingMortgage
     * @uses ExistingMortgage::setMortgageTypeId()
     * @uses ExistingMortgage::setPAndIPaymentAmount()
     * @uses ExistingMortgage::setPaymentFrequencyId()
     * @uses ExistingMortgage::setMaturityDate()
     * @uses ExistingMortgage::setInterestTypeId()
     * @uses ExistingMortgage::setPaymentTermId()
     * @uses ExistingMortgage::setBalanceRemaining()
     * @uses ExistingMortgage::setExistingMortgageHolder()
     * @uses ExistingMortgage::setPayoffTypeId()
     * @uses ExistingMortgage::setInterestRate()
     * @uses ExistingMortgage::setLoanAmount()
     * @uses ExistingMortgage::setInterestOnly()
     * @param string $mortgageTypeId
     * @param float $pAndIPaymentAmount
     * @param string $paymentFrequencyId
     * @param string $maturityDate
     * @param string $interestTypeId
     * @param string $paymentTermId
     * @param float $balanceRemaining
     * @param string $existingMortgageHolder
     * @param string $payoffTypeId
     * @param float $interestRate
     * @param float $loanAmount
     * @param bool $interestOnly
     */
    public function __construct($mortgageTypeId = null, $pAndIPaymentAmount = null, $paymentFrequencyId = null, $maturityDate = null, $interestTypeId = null, $paymentTermId = null, $balanceRemaining = null, $existingMortgageHolder = null, $payoffTypeId = null, $interestRate = null, $loanAmount = null, $interestOnly = null)
    {
        $this
            ->setMortgageTypeId($mortgageTypeId)
            ->setPAndIPaymentAmount($pAndIPaymentAmount)
            ->setPaymentFrequencyId($paymentFrequencyId)
            ->setMaturityDate($maturityDate)
            ->setInterestTypeId($interestTypeId)
            ->setPaymentTermId($paymentTermId)
            ->setBalanceRemaining($balanceRemaining)
            ->setExistingMortgageHolder($existingMortgageHolder)
            ->setPayoffTypeId($payoffTypeId)
            ->setInterestRate($interestRate)
            ->setLoanAmount($loanAmount)
            ->setInterestOnly($interestOnly);
    }
    /**
     * Get MortgageTypeId value
     * @return string
     */
    public function getMortgageTypeId()
    {
        return $this->MortgageTypeId;
    }
    /**
     * Set MortgageTypeId value
     * @uses \TurnedAwayBOSS\EnumType\MortgageType::valueIsValid()
     * @uses \TurnedAwayBOSS\EnumType\MortgageType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mortgageTypeId
     * @return \TurnedAwayBOSS\StructType\ExistingMortgage
     */
    public function setMortgageTypeId($mortgageTypeId = null)
    {
        // validation for constraint: enumeration
        if (!\TurnedAwayBOSS\EnumType\MortgageType::valueIsValid($mortgageTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \TurnedAwayBOSS\EnumType\MortgageType', is_array($mortgageTypeId) ? implode(', ', $mortgageTypeId) : var_export($mortgageTypeId, true), implode(', ', \TurnedAwayBOSS\EnumType\MortgageType::getValidValues())), __LINE__);
        }
        $this->MortgageTypeId = $mortgageTypeId;
        return $this;
    }
    /**
     * Get PAndIPaymentAmount value
     * @return float
     */
    public function getPAndIPaymentAmount()
    {
        return $this->PAndIPaymentAmount;
    }
    /**
     * Set PAndIPaymentAmount value
     * @param float $pAndIPaymentAmount
     * @return \TurnedAwayBOSS\StructType\ExistingMortgage
     */
    public function setPAndIPaymentAmount($pAndIPaymentAmount = null)
    {
        // validation for constraint: float
        if (!is_null($pAndIPaymentAmount) && !(is_float($pAndIPaymentAmount) || is_numeric($pAndIPaymentAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pAndIPaymentAmount, true), gettype($pAndIPaymentAmount)), __LINE__);
        }
        $this->PAndIPaymentAmount = $pAndIPaymentAmount;
        return $this;
    }
    /**
     * Get PaymentFrequencyId value
     * @return string
     */
    public function getPaymentFrequencyId()
    {
        return $this->PaymentFrequencyId;
    }
    /**
     * Set PaymentFrequencyId value
     * @uses \TurnedAwayBOSS\EnumType\PaymentFrequency::valueIsValid()
     * @uses \TurnedAwayBOSS\EnumType\PaymentFrequency::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentFrequencyId
     * @return \TurnedAwayBOSS\StructType\ExistingMortgage
     */
    public function setPaymentFrequencyId($paymentFrequencyId = null)
    {
        // validation for constraint: enumeration
        if (!\TurnedAwayBOSS\EnumType\PaymentFrequency::valueIsValid($paymentFrequencyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \TurnedAwayBOSS\EnumType\PaymentFrequency', is_array($paymentFrequencyId) ? implode(', ', $paymentFrequencyId) : var_export($paymentFrequencyId, true), implode(', ', \TurnedAwayBOSS\EnumType\PaymentFrequency::getValidValues())), __LINE__);
        }
        $this->PaymentFrequencyId = $paymentFrequencyId;
        return $this;
    }
    /**
     * Get MaturityDate value
     * @return string
     */
    public function getMaturityDate()
    {
        return $this->MaturityDate;
    }
    /**
     * Set MaturityDate value
     * @param string $maturityDate
     * @return \TurnedAwayBOSS\StructType\ExistingMortgage
     */
    public function setMaturityDate($maturityDate = null)
    {
        // validation for constraint: string
        if (!is_null($maturityDate) && !is_string($maturityDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maturityDate, true), gettype($maturityDate)), __LINE__);
        }
        $this->MaturityDate = $maturityDate;
        return $this;
    }
    /**
     * Get InterestTypeId value
     * @return string
     */
    public function getInterestTypeId()
    {
        return $this->InterestTypeId;
    }
    /**
     * Set InterestTypeId value
     * @uses \TurnedAwayBOSS\EnumType\InterestType::valueIsValid()
     * @uses \TurnedAwayBOSS\EnumType\InterestType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $interestTypeId
     * @return \TurnedAwayBOSS\StructType\ExistingMortgage
     */
    public function setInterestTypeId($interestTypeId = null)
    {
        // validation for constraint: enumeration
        if (!\TurnedAwayBOSS\EnumType\InterestType::valueIsValid($interestTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \TurnedAwayBOSS\EnumType\InterestType', is_array($interestTypeId) ? implode(', ', $interestTypeId) : var_export($interestTypeId, true), implode(', ', \TurnedAwayBOSS\EnumType\InterestType::getValidValues())), __LINE__);
        }
        $this->InterestTypeId = $interestTypeId;
        return $this;
    }
    /**
     * Get PaymentTermId value
     * @return string
     */
    public function getPaymentTermId()
    {
        return $this->PaymentTermId;
    }
    /**
     * Set PaymentTermId value
     * @uses \TurnedAwayBOSS\EnumType\PaymentTerm::valueIsValid()
     * @uses \TurnedAwayBOSS\EnumType\PaymentTerm::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentTermId
     * @return \TurnedAwayBOSS\StructType\ExistingMortgage
     */
    public function setPaymentTermId($paymentTermId = null)
    {
        // validation for constraint: enumeration
        if (!\TurnedAwayBOSS\EnumType\PaymentTerm::valueIsValid($paymentTermId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \TurnedAwayBOSS\EnumType\PaymentTerm', is_array($paymentTermId) ? implode(', ', $paymentTermId) : var_export($paymentTermId, true), implode(', ', \TurnedAwayBOSS\EnumType\PaymentTerm::getValidValues())), __LINE__);
        }
        $this->PaymentTermId = $paymentTermId;
        return $this;
    }
    /**
     * Get BalanceRemaining value
     * @return float
     */
    public function getBalanceRemaining()
    {
        return $this->BalanceRemaining;
    }
    /**
     * Set BalanceRemaining value
     * @param float $balanceRemaining
     * @return \TurnedAwayBOSS\StructType\ExistingMortgage
     */
    public function setBalanceRemaining($balanceRemaining = null)
    {
        // validation for constraint: float
        if (!is_null($balanceRemaining) && !(is_float($balanceRemaining) || is_numeric($balanceRemaining))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($balanceRemaining, true), gettype($balanceRemaining)), __LINE__);
        }
        $this->BalanceRemaining = $balanceRemaining;
        return $this;
    }
    /**
     * Get ExistingMortgageHolder value
     * @return string
     */
    public function getExistingMortgageHolder()
    {
        return $this->ExistingMortgageHolder;
    }
    /**
     * Set ExistingMortgageHolder value
     * @param string $existingMortgageHolder
     * @return \TurnedAwayBOSS\StructType\ExistingMortgage
     */
    public function setExistingMortgageHolder($existingMortgageHolder = null)
    {
        // validation for constraint: string
        if (!is_null($existingMortgageHolder) && !is_string($existingMortgageHolder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($existingMortgageHolder, true), gettype($existingMortgageHolder)), __LINE__);
        }
        $this->ExistingMortgageHolder = $existingMortgageHolder;
        return $this;
    }
    /**
     * Get PayoffTypeId value
     * @return string
     */
    public function getPayoffTypeId()
    {
        return $this->PayoffTypeId;
    }
    /**
     * Set PayoffTypeId value
     * @uses \TurnedAwayBOSS\EnumType\PayOffType::valueIsValid()
     * @uses \TurnedAwayBOSS\EnumType\PayOffType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $payoffTypeId
     * @return \TurnedAwayBOSS\StructType\ExistingMortgage
     */
    public function setPayoffTypeId($payoffTypeId = null)
    {
        // validation for constraint: enumeration
        if (!\TurnedAwayBOSS\EnumType\PayOffType::valueIsValid($payoffTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \TurnedAwayBOSS\EnumType\PayOffType', is_array($payoffTypeId) ? implode(', ', $payoffTypeId) : var_export($payoffTypeId, true), implode(', ', \TurnedAwayBOSS\EnumType\PayOffType::getValidValues())), __LINE__);
        }
        $this->PayoffTypeId = $payoffTypeId;
        return $this;
    }
    /**
     * Get InterestRate value
     * @return float
     */
    public function getInterestRate()
    {
        return $this->InterestRate;
    }
    /**
     * Set InterestRate value
     * @param float $interestRate
     * @return \TurnedAwayBOSS\StructType\ExistingMortgage
     */
    public function setInterestRate($interestRate = null)
    {
        // validation for constraint: float
        if (!is_null($interestRate) && !(is_float($interestRate) || is_numeric($interestRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($interestRate, true), gettype($interestRate)), __LINE__);
        }
        $this->InterestRate = $interestRate;
        return $this;
    }
    /**
     * Get LoanAmount value
     * @return float
     */
    public function getLoanAmount()
    {
        return $this->LoanAmount;
    }
    /**
     * Set LoanAmount value
     * @param float $loanAmount
     * @return \TurnedAwayBOSS\StructType\ExistingMortgage
     */
    public function setLoanAmount($loanAmount = null)
    {
        // validation for constraint: float
        if (!is_null($loanAmount) && !(is_float($loanAmount) || is_numeric($loanAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($loanAmount, true), gettype($loanAmount)), __LINE__);
        }
        $this->LoanAmount = $loanAmount;
        return $this;
    }
    /**
     * Get InterestOnly value
     * @return bool
     */
    public function getInterestOnly()
    {
        return $this->InterestOnly;
    }
    /**
     * Set InterestOnly value
     * @param bool $interestOnly
     * @return \TurnedAwayBOSS\StructType\ExistingMortgage
     */
    public function setInterestOnly($interestOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($interestOnly) && !is_bool($interestOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($interestOnly, true), gettype($interestOnly)), __LINE__);
        }
        $this->InterestOnly = $interestOnly;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \TurnedAwayBOSS\StructType\ExistingMortgage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
