<?php

namespace TurnedAwayBOSS\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EmploymentContact StructType
 * @subpackage Structs
 */
class EmploymentContact extends AbstractStructBase
{
    /**
     * The EmployerName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $EmployerName;
    /**
     * The ContactEmailAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ContactEmailAddress;
    /**
     * The EmploymentHistoryStatusId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $EmploymentHistoryStatusId;
    /**
     * The EmploymentHistoryTypeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $EmploymentHistoryTypeId;
    /**
     * The EmployerPhones
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \TurnedAwayBOSS\StructType\Phone[]
     */
    public $EmployerPhones;
    /**
     * Constructor method for EmploymentContact
     * @uses EmploymentContact::setEmployerName()
     * @uses EmploymentContact::setContactEmailAddress()
     * @uses EmploymentContact::setEmploymentHistoryStatusId()
     * @uses EmploymentContact::setEmploymentHistoryTypeId()
     * @uses EmploymentContact::setEmployerPhones()
     * @param string $employerName
     * @param string $contactEmailAddress
     * @param string $employmentHistoryStatusId
     * @param string $employmentHistoryTypeId
     * @param \TurnedAwayBOSS\StructType\Phone[] $employerPhones
     */
    public function __construct($employerName = null, $contactEmailAddress = null, $employmentHistoryStatusId = null, $employmentHistoryTypeId = null, array $employerPhones = array())
    {
        $this
            ->setEmployerName($employerName)
            ->setContactEmailAddress($contactEmailAddress)
            ->setEmploymentHistoryStatusId($employmentHistoryStatusId)
            ->setEmploymentHistoryTypeId($employmentHistoryTypeId)
            ->setEmployerPhones($employerPhones);
    }
    /**
     * Get EmployerName value
     * @return string
     */
    public function getEmployerName()
    {
        return $this->EmployerName;
    }
    /**
     * Set EmployerName value
     * @param string $employerName
     * @return \TurnedAwayBOSS\StructType\EmploymentContact
     */
    public function setEmployerName($employerName = null)
    {
        // validation for constraint: string
        if (!is_null($employerName) && !is_string($employerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($employerName, true), gettype($employerName)), __LINE__);
        }
        $this->EmployerName = $employerName;
        return $this;
    }
    /**
     * Get ContactEmailAddress value
     * @return string
     */
    public function getContactEmailAddress()
    {
        return $this->ContactEmailAddress;
    }
    /**
     * Set ContactEmailAddress value
     * @param string $contactEmailAddress
     * @return \TurnedAwayBOSS\StructType\EmploymentContact
     */
    public function setContactEmailAddress($contactEmailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($contactEmailAddress) && !is_string($contactEmailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactEmailAddress, true), gettype($contactEmailAddress)), __LINE__);
        }
        $this->ContactEmailAddress = $contactEmailAddress;
        return $this;
    }
    /**
     * Get EmploymentHistoryStatusId value
     * @return string
     */
    public function getEmploymentHistoryStatusId()
    {
        return $this->EmploymentHistoryStatusId;
    }
    /**
     * Set EmploymentHistoryStatusId value
     * @uses \TurnedAwayBOSS\EnumType\EmploymentHistoryStatus::valueIsValid()
     * @uses \TurnedAwayBOSS\EnumType\EmploymentHistoryStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $employmentHistoryStatusId
     * @return \TurnedAwayBOSS\StructType\EmploymentContact
     */
    public function setEmploymentHistoryStatusId($employmentHistoryStatusId = null)
    {
        // validation for constraint: enumeration
        if (!\TurnedAwayBOSS\EnumType\EmploymentHistoryStatus::valueIsValid($employmentHistoryStatusId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \TurnedAwayBOSS\EnumType\EmploymentHistoryStatus', is_array($employmentHistoryStatusId) ? implode(', ', $employmentHistoryStatusId) : var_export($employmentHistoryStatusId, true), implode(', ', \TurnedAwayBOSS\EnumType\EmploymentHistoryStatus::getValidValues())), __LINE__);
        }
        $this->EmploymentHistoryStatusId = $employmentHistoryStatusId;
        return $this;
    }
    /**
     * Get EmploymentHistoryTypeId value
     * @return string
     */
    public function getEmploymentHistoryTypeId()
    {
        return $this->EmploymentHistoryTypeId;
    }
    /**
     * Set EmploymentHistoryTypeId value
     * @uses \TurnedAwayBOSS\EnumType\EmploymentHistoryType::valueIsValid()
     * @uses \TurnedAwayBOSS\EnumType\EmploymentHistoryType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $employmentHistoryTypeId
     * @return \TurnedAwayBOSS\StructType\EmploymentContact
     */
    public function setEmploymentHistoryTypeId($employmentHistoryTypeId = null)
    {
        // validation for constraint: enumeration
        if (!\TurnedAwayBOSS\EnumType\EmploymentHistoryType::valueIsValid($employmentHistoryTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \TurnedAwayBOSS\EnumType\EmploymentHistoryType', is_array($employmentHistoryTypeId) ? implode(', ', $employmentHistoryTypeId) : var_export($employmentHistoryTypeId, true), implode(', ', \TurnedAwayBOSS\EnumType\EmploymentHistoryType::getValidValues())), __LINE__);
        }
        $this->EmploymentHistoryTypeId = $employmentHistoryTypeId;
        return $this;
    }
    /**
     * Get EmployerPhones value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \TurnedAwayBOSS\StructType\Phone[]|null
     */
    public function getEmployerPhones()
    {
        return isset($this->EmployerPhones) ? $this->EmployerPhones : null;
    }
    /**
     * This method is responsible for validating the values passed to the setEmployerPhones method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEmployerPhones method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEmployerPhonesForArrayConstraintsFromSetEmployerPhones(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $employmentContactEmployerPhonesItem) {
            // validation for constraint: itemType
            if (!$employmentContactEmployerPhonesItem instanceof \TurnedAwayBOSS\StructType\Phone) {
                $invalidValues[] = is_object($employmentContactEmployerPhonesItem) ? get_class($employmentContactEmployerPhonesItem) : sprintf('%s(%s)', gettype($employmentContactEmployerPhonesItem), var_export($employmentContactEmployerPhonesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The EmployerPhones property can only contain items of type \TurnedAwayBOSS\StructType\Phone, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set EmployerPhones value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \TurnedAwayBOSS\StructType\Phone[] $employerPhones
     * @return \TurnedAwayBOSS\StructType\EmploymentContact
     */
    public function setEmployerPhones(array $employerPhones = array())
    {
        // validation for constraint: array
        if ('' !== ($employerPhonesArrayErrorMessage = self::validateEmployerPhonesForArrayConstraintsFromSetEmployerPhones($employerPhones))) {
            throw new \InvalidArgumentException($employerPhonesArrayErrorMessage, __LINE__);
        }
        if (is_null($employerPhones) || (is_array($employerPhones) && empty($employerPhones))) {
            unset($this->EmployerPhones);
        } else {
            $this->EmployerPhones = $employerPhones;
        }
        return $this;
    }
    /**
     * Add item to EmployerPhones value
     * @throws \InvalidArgumentException
     * @param \TurnedAwayBOSS\StructType\Phone $item
     * @return \TurnedAwayBOSS\StructType\EmploymentContact
     */
    public function addToEmployerPhones(\TurnedAwayBOSS\StructType\Phone $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \TurnedAwayBOSS\StructType\Phone) {
            throw new \InvalidArgumentException(sprintf('The EmployerPhones property can only contain items of type \TurnedAwayBOSS\StructType\Phone, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->EmployerPhones[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \TurnedAwayBOSS\StructType\EmploymentContact
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
