<?php

namespace TurnedAwayBOSS\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Employment StructType
 * @subpackage Structs
 */
class Employment extends AbstractStructBase
{
    /**
     * The Contact
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \TurnedAwayBOSS\StructType\EmploymentContact
     */
    public $Contact;
    /**
     * The EmployerAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \TurnedAwayBOSS\StructType\Address
     */
    public $EmployerAddress;
    /**
     * The Income
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \TurnedAwayBOSS\StructType\Income
     */
    public $Income;
    /**
     * The IndustrySectorid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $IndustrySectorid;
    /**
     * The JobTitle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $JobTitle;
    /**
     * The MonthsOfService
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $MonthsOfService;
    /**
     * The OccupationId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $OccupationId;
    /**
     * The SelfEmploymentDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \TurnedAwayBOSS\StructType\SelfEmploymentDetail
     */
    public $SelfEmploymentDetail;
    /**
     * The TimeInIndustry
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $TimeInIndustry;
    /**
     * The StartDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $StartDate;
    /**
     * Constructor method for Employment
     * @uses Employment::setContact()
     * @uses Employment::setEmployerAddress()
     * @uses Employment::setIncome()
     * @uses Employment::setIndustrySectorid()
     * @uses Employment::setJobTitle()
     * @uses Employment::setMonthsOfService()
     * @uses Employment::setOccupationId()
     * @uses Employment::setSelfEmploymentDetail()
     * @uses Employment::setTimeInIndustry()
     * @uses Employment::setStartDate()
     * @param \TurnedAwayBOSS\StructType\EmploymentContact $contact
     * @param \TurnedAwayBOSS\StructType\Address $employerAddress
     * @param \TurnedAwayBOSS\StructType\Income $income
     * @param string $industrySectorid
     * @param string $jobTitle
     * @param int $monthsOfService
     * @param string $occupationId
     * @param \TurnedAwayBOSS\StructType\SelfEmploymentDetail $selfEmploymentDetail
     * @param int $timeInIndustry
     * @param string $startDate
     */
    public function __construct(\TurnedAwayBOSS\StructType\EmploymentContact $contact = null, \TurnedAwayBOSS\StructType\Address $employerAddress = null, \TurnedAwayBOSS\StructType\Income $income = null, $industrySectorid = null, $jobTitle = null, $monthsOfService = null, $occupationId = null, \TurnedAwayBOSS\StructType\SelfEmploymentDetail $selfEmploymentDetail = null, $timeInIndustry = null, $startDate = null)
    {
        $this
            ->setContact($contact)
            ->setEmployerAddress($employerAddress)
            ->setIncome($income)
            ->setIndustrySectorid($industrySectorid)
            ->setJobTitle($jobTitle)
            ->setMonthsOfService($monthsOfService)
            ->setOccupationId($occupationId)
            ->setSelfEmploymentDetail($selfEmploymentDetail)
            ->setTimeInIndustry($timeInIndustry)
            ->setStartDate($startDate);
    }
    /**
     * Get Contact value
     * @return \TurnedAwayBOSS\StructType\EmploymentContact
     */
    public function getContact()
    {
        return $this->Contact;
    }
    /**
     * Set Contact value
     * @param \TurnedAwayBOSS\StructType\EmploymentContact $contact
     * @return \TurnedAwayBOSS\StructType\Employment
     */
    public function setContact(\TurnedAwayBOSS\StructType\EmploymentContact $contact = null)
    {
        $this->Contact = $contact;
        return $this;
    }
    /**
     * Get EmployerAddress value
     * @return \TurnedAwayBOSS\StructType\Address
     */
    public function getEmployerAddress()
    {
        return $this->EmployerAddress;
    }
    /**
     * Set EmployerAddress value
     * @param \TurnedAwayBOSS\StructType\Address $employerAddress
     * @return \TurnedAwayBOSS\StructType\Employment
     */
    public function setEmployerAddress(\TurnedAwayBOSS\StructType\Address $employerAddress = null)
    {
        $this->EmployerAddress = $employerAddress;
        return $this;
    }
    /**
     * Get Income value
     * @return \TurnedAwayBOSS\StructType\Income
     */
    public function getIncome()
    {
        return $this->Income;
    }
    /**
     * Set Income value
     * @param \TurnedAwayBOSS\StructType\Income $income
     * @return \TurnedAwayBOSS\StructType\Employment
     */
    public function setIncome(\TurnedAwayBOSS\StructType\Income $income = null)
    {
        $this->Income = $income;
        return $this;
    }
    /**
     * Get IndustrySectorid value
     * @return string
     */
    public function getIndustrySectorid()
    {
        return $this->IndustrySectorid;
    }
    /**
     * Set IndustrySectorid value
     * @uses \TurnedAwayBOSS\EnumType\IndustrySector::valueIsValid()
     * @uses \TurnedAwayBOSS\EnumType\IndustrySector::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $industrySectorid
     * @return \TurnedAwayBOSS\StructType\Employment
     */
    public function setIndustrySectorid($industrySectorid = null)
    {
        // validation for constraint: enumeration
        if (!\TurnedAwayBOSS\EnumType\IndustrySector::valueIsValid($industrySectorid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \TurnedAwayBOSS\EnumType\IndustrySector', is_array($industrySectorid) ? implode(', ', $industrySectorid) : var_export($industrySectorid, true), implode(', ', \TurnedAwayBOSS\EnumType\IndustrySector::getValidValues())), __LINE__);
        }
        $this->IndustrySectorid = $industrySectorid;
        return $this;
    }
    /**
     * Get JobTitle value
     * @return string
     */
    public function getJobTitle()
    {
        return $this->JobTitle;
    }
    /**
     * Set JobTitle value
     * @param string $jobTitle
     * @return \TurnedAwayBOSS\StructType\Employment
     */
    public function setJobTitle($jobTitle = null)
    {
        // validation for constraint: string
        if (!is_null($jobTitle) && !is_string($jobTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($jobTitle, true), gettype($jobTitle)), __LINE__);
        }
        $this->JobTitle = $jobTitle;
        return $this;
    }
    /**
     * Get MonthsOfService value
     * @return int
     */
    public function getMonthsOfService()
    {
        return $this->MonthsOfService;
    }
    /**
     * Set MonthsOfService value
     * @param int $monthsOfService
     * @return \TurnedAwayBOSS\StructType\Employment
     */
    public function setMonthsOfService($monthsOfService = null)
    {
        // validation for constraint: int
        if (!is_null($monthsOfService) && !(is_int($monthsOfService) || ctype_digit($monthsOfService))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($monthsOfService, true), gettype($monthsOfService)), __LINE__);
        }
        $this->MonthsOfService = $monthsOfService;
        return $this;
    }
    /**
     * Get OccupationId value
     * @return string
     */
    public function getOccupationId()
    {
        return $this->OccupationId;
    }
    /**
     * Set OccupationId value
     * @uses \TurnedAwayBOSS\EnumType\Occupation::valueIsValid()
     * @uses \TurnedAwayBOSS\EnumType\Occupation::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $occupationId
     * @return \TurnedAwayBOSS\StructType\Employment
     */
    public function setOccupationId($occupationId = null)
    {
        // validation for constraint: enumeration
        if (!\TurnedAwayBOSS\EnumType\Occupation::valueIsValid($occupationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \TurnedAwayBOSS\EnumType\Occupation', is_array($occupationId) ? implode(', ', $occupationId) : var_export($occupationId, true), implode(', ', \TurnedAwayBOSS\EnumType\Occupation::getValidValues())), __LINE__);
        }
        $this->OccupationId = $occupationId;
        return $this;
    }
    /**
     * Get SelfEmploymentDetail value
     * @return \TurnedAwayBOSS\StructType\SelfEmploymentDetail
     */
    public function getSelfEmploymentDetail()
    {
        return $this->SelfEmploymentDetail;
    }
    /**
     * Set SelfEmploymentDetail value
     * @param \TurnedAwayBOSS\StructType\SelfEmploymentDetail $selfEmploymentDetail
     * @return \TurnedAwayBOSS\StructType\Employment
     */
    public function setSelfEmploymentDetail(\TurnedAwayBOSS\StructType\SelfEmploymentDetail $selfEmploymentDetail = null)
    {
        $this->SelfEmploymentDetail = $selfEmploymentDetail;
        return $this;
    }
    /**
     * Get TimeInIndustry value
     * @return int
     */
    public function getTimeInIndustry()
    {
        return $this->TimeInIndustry;
    }
    /**
     * Set TimeInIndustry value
     * @param int $timeInIndustry
     * @return \TurnedAwayBOSS\StructType\Employment
     */
    public function setTimeInIndustry($timeInIndustry = null)
    {
        // validation for constraint: int
        if (!is_null($timeInIndustry) && !(is_int($timeInIndustry) || ctype_digit($timeInIndustry))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($timeInIndustry, true), gettype($timeInIndustry)), __LINE__);
        }
        $this->TimeInIndustry = $timeInIndustry;
        return $this;
    }
    /**
     * Get StartDate value
     * @return string
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \TurnedAwayBOSS\StructType\Employment
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \TurnedAwayBOSS\StructType\Employment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
