<?php

namespace TurnedAwayBOSS\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Deal StructType
 * @subpackage Structs
 */
class Deal extends AbstractStructBase
{
    /**
     * The XmlDealVersion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $XmlDealVersion;
    /**
     * The LeadWorkflow
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \TurnedAwayBOSS\StructType\LeadWorkflow
     */
    public $LeadWorkflow;
    /**
     * The Broker
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \TurnedAwayBOSS\StructType\Broker
     */
    public $Broker;
    /**
     * The DealInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \TurnedAwayBOSS\StructType\DealInfo
     */
    public $DealInfo;
    /**
     * The SubjectProperty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \TurnedAwayBOSS\StructType\SubjectProperty
     */
    public $SubjectProperty;
    /**
     * The MortgageRequests
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurnedAwayBOSS\ArrayType\ArrayOfMortgageRequest
     */
    public $MortgageRequests;
    /**
     * The ApplicantGroups
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \TurnedAwayBOSS\ArrayType\ArrayOfApplicantGroup
     */
    public $ApplicantGroups;
    /**
     * Constructor method for Deal
     * @uses Deal::setXmlDealVersion()
     * @uses Deal::setLeadWorkflow()
     * @uses Deal::setBroker()
     * @uses Deal::setDealInfo()
     * @uses Deal::setSubjectProperty()
     * @uses Deal::setMortgageRequests()
     * @uses Deal::setApplicantGroups()
     * @param string $xmlDealVersion
     * @param \TurnedAwayBOSS\StructType\LeadWorkflow $leadWorkflow
     * @param \TurnedAwayBOSS\StructType\Broker $broker
     * @param \TurnedAwayBOSS\StructType\DealInfo $dealInfo
     * @param \TurnedAwayBOSS\StructType\SubjectProperty $subjectProperty
     * @param \TurnedAwayBOSS\ArrayType\ArrayOfMortgageRequest $mortgageRequests
     * @param \TurnedAwayBOSS\ArrayType\ArrayOfApplicantGroup $applicantGroups
     */
    public function __construct($xmlDealVersion = null, \TurnedAwayBOSS\StructType\LeadWorkflow $leadWorkflow = null, \TurnedAwayBOSS\StructType\Broker $broker = null, \TurnedAwayBOSS\StructType\DealInfo $dealInfo = null, \TurnedAwayBOSS\StructType\SubjectProperty $subjectProperty = null, \TurnedAwayBOSS\ArrayType\ArrayOfMortgageRequest $mortgageRequests = null, \TurnedAwayBOSS\ArrayType\ArrayOfApplicantGroup $applicantGroups = null)
    {
        $this
            ->setXmlDealVersion($xmlDealVersion)
            ->setLeadWorkflow($leadWorkflow)
            ->setBroker($broker)
            ->setDealInfo($dealInfo)
            ->setSubjectProperty($subjectProperty)
            ->setMortgageRequests($mortgageRequests)
            ->setApplicantGroups($applicantGroups);
    }
    /**
     * Get XmlDealVersion value
     * @return string
     */
    public function getXmlDealVersion()
    {
        return $this->XmlDealVersion;
    }
    /**
     * Set XmlDealVersion value
     * @param string $xmlDealVersion
     * @return \TurnedAwayBOSS\StructType\Deal
     */
    public function setXmlDealVersion($xmlDealVersion = null)
    {
        // validation for constraint: string
        if (!is_null($xmlDealVersion) && !is_string($xmlDealVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($xmlDealVersion, true), gettype($xmlDealVersion)), __LINE__);
        }
        $this->XmlDealVersion = $xmlDealVersion;
        return $this;
    }
    /**
     * Get LeadWorkflow value
     * @return \TurnedAwayBOSS\StructType\LeadWorkflow
     */
    public function getLeadWorkflow()
    {
        return $this->LeadWorkflow;
    }
    /**
     * Set LeadWorkflow value
     * @param \TurnedAwayBOSS\StructType\LeadWorkflow $leadWorkflow
     * @return \TurnedAwayBOSS\StructType\Deal
     */
    public function setLeadWorkflow(\TurnedAwayBOSS\StructType\LeadWorkflow $leadWorkflow = null)
    {
        $this->LeadWorkflow = $leadWorkflow;
        return $this;
    }
    /**
     * Get Broker value
     * @return \TurnedAwayBOSS\StructType\Broker
     */
    public function getBroker()
    {
        return $this->Broker;
    }
    /**
     * Set Broker value
     * @param \TurnedAwayBOSS\StructType\Broker $broker
     * @return \TurnedAwayBOSS\StructType\Deal
     */
    public function setBroker(\TurnedAwayBOSS\StructType\Broker $broker = null)
    {
        $this->Broker = $broker;
        return $this;
    }
    /**
     * Get DealInfo value
     * @return \TurnedAwayBOSS\StructType\DealInfo
     */
    public function getDealInfo()
    {
        return $this->DealInfo;
    }
    /**
     * Set DealInfo value
     * @param \TurnedAwayBOSS\StructType\DealInfo $dealInfo
     * @return \TurnedAwayBOSS\StructType\Deal
     */
    public function setDealInfo(\TurnedAwayBOSS\StructType\DealInfo $dealInfo = null)
    {
        $this->DealInfo = $dealInfo;
        return $this;
    }
    /**
     * Get SubjectProperty value
     * @return \TurnedAwayBOSS\StructType\SubjectProperty
     */
    public function getSubjectProperty()
    {
        return $this->SubjectProperty;
    }
    /**
     * Set SubjectProperty value
     * @param \TurnedAwayBOSS\StructType\SubjectProperty $subjectProperty
     * @return \TurnedAwayBOSS\StructType\Deal
     */
    public function setSubjectProperty(\TurnedAwayBOSS\StructType\SubjectProperty $subjectProperty = null)
    {
        $this->SubjectProperty = $subjectProperty;
        return $this;
    }
    /**
     * Get MortgageRequests value
     * @return \TurnedAwayBOSS\ArrayType\ArrayOfMortgageRequest|null
     */
    public function getMortgageRequests()
    {
        return $this->MortgageRequests;
    }
    /**
     * Set MortgageRequests value
     * @param \TurnedAwayBOSS\ArrayType\ArrayOfMortgageRequest $mortgageRequests
     * @return \TurnedAwayBOSS\StructType\Deal
     */
    public function setMortgageRequests(\TurnedAwayBOSS\ArrayType\ArrayOfMortgageRequest $mortgageRequests = null)
    {
        $this->MortgageRequests = $mortgageRequests;
        return $this;
    }
    /**
     * Get ApplicantGroups value
     * @return \TurnedAwayBOSS\ArrayType\ArrayOfApplicantGroup|null
     */
    public function getApplicantGroups()
    {
        return $this->ApplicantGroups;
    }
    /**
     * Set ApplicantGroups value
     * @param \TurnedAwayBOSS\ArrayType\ArrayOfApplicantGroup $applicantGroups
     * @return \TurnedAwayBOSS\StructType\Deal
     */
    public function setApplicantGroups(\TurnedAwayBOSS\ArrayType\ArrayOfApplicantGroup $applicantGroups = null)
    {
        $this->ApplicantGroups = $applicantGroups;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \TurnedAwayBOSS\StructType\Deal
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
