<?php

namespace TurnedAwayBOSS\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Broker StructType
 * @subpackage Structs
 */
class Broker extends AbstractStructBase
{
    /**
     * The BrokerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BrokerId;
    /**
     * Constructor method for Broker
     * @uses Broker::setBrokerId()
     * @param int $brokerId
     */
    public function __construct($brokerId = null)
    {
        $this
            ->setBrokerId($brokerId);
    }
    /**
     * Get BrokerId value
     * @return int
     */
    public function getBrokerId()
    {
        return $this->BrokerId;
    }
    /**
     * Set BrokerId value
     * @param int $brokerId
     * @return \TurnedAwayBOSS\StructType\Broker
     */
    public function setBrokerId($brokerId = null)
    {
        // validation for constraint: int
        if (!is_null($brokerId) && !(is_int($brokerId) || ctype_digit($brokerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($brokerId, true), gettype($brokerId)), __LINE__);
        }
        $this->BrokerId = $brokerId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \TurnedAwayBOSS\StructType\Broker
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
