<?php

namespace TurnedAwayBOSS\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Asset StructType
 * @subpackage Structs
 */
class Asset extends AbstractStructBase
{
    /**
     * The AssetDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $AssetDescription;
    /**
     * The AssetTypeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $AssetTypeId;
    /**
     * The AssetValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $AssetValue;
    /**
     * Constructor method for Asset
     * @uses Asset::setAssetDescription()
     * @uses Asset::setAssetTypeId()
     * @uses Asset::setAssetValue()
     * @param string $assetDescription
     * @param string $assetTypeId
     * @param float $assetValue
     */
    public function __construct($assetDescription = null, $assetTypeId = null, $assetValue = null)
    {
        $this
            ->setAssetDescription($assetDescription)
            ->setAssetTypeId($assetTypeId)
            ->setAssetValue($assetValue);
    }
    /**
     * Get AssetDescription value
     * @return string
     */
    public function getAssetDescription()
    {
        return $this->AssetDescription;
    }
    /**
     * Set AssetDescription value
     * @param string $assetDescription
     * @return \TurnedAwayBOSS\StructType\Asset
     */
    public function setAssetDescription($assetDescription = null)
    {
        // validation for constraint: string
        if (!is_null($assetDescription) && !is_string($assetDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($assetDescription, true), gettype($assetDescription)), __LINE__);
        }
        $this->AssetDescription = $assetDescription;
        return $this;
    }
    /**
     * Get AssetTypeId value
     * @return string
     */
    public function getAssetTypeId()
    {
        return $this->AssetTypeId;
    }
    /**
     * Set AssetTypeId value
     * @uses \TurnedAwayBOSS\EnumType\AssetType::valueIsValid()
     * @uses \TurnedAwayBOSS\EnumType\AssetType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $assetTypeId
     * @return \TurnedAwayBOSS\StructType\Asset
     */
    public function setAssetTypeId($assetTypeId = null)
    {
        // validation for constraint: enumeration
        if (!\TurnedAwayBOSS\EnumType\AssetType::valueIsValid($assetTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \TurnedAwayBOSS\EnumType\AssetType', is_array($assetTypeId) ? implode(', ', $assetTypeId) : var_export($assetTypeId, true), implode(', ', \TurnedAwayBOSS\EnumType\AssetType::getValidValues())), __LINE__);
        }
        $this->AssetTypeId = $assetTypeId;
        return $this;
    }
    /**
     * Get AssetValue value
     * @return float
     */
    public function getAssetValue()
    {
        return $this->AssetValue;
    }
    /**
     * Set AssetValue value
     * @param float $assetValue
     * @return \TurnedAwayBOSS\StructType\Asset
     */
    public function setAssetValue($assetValue = null)
    {
        // validation for constraint: float
        if (!is_null($assetValue) && !(is_float($assetValue) || is_numeric($assetValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($assetValue, true), gettype($assetValue)), __LINE__);
        }
        $this->AssetValue = $assetValue;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \TurnedAwayBOSS\StructType\Asset
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
